<?php
/**
 * Query
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Traits;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports;

/**
 * Query
 *
 * @since 3.9.0
 */
trait Query {

	/**
	 * Gets the product for the query.
	 *
	 * @since 3.9.0
	 * @return int|false
	 */
	protected function get_product() {
		$product = Reports\get_filter_value( 'products' );
		if ( empty( $product ) || 'all' === $product ) {
			return false;
		}
		return (int) $product;
	}

	/**
	 * Gets the SQL query for the product for the license_activationmeta table.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_product_sql_query() {
		$product = $this->get_product();
		if ( ! $product ) {
			return '';
		}

		global $wpdb;

		return $wpdb->prepare(
			" AND id IN ( SELECT edd_license_activation_id FROM {$wpdb->prefix}edd_license_activationmeta WHERE meta_value = %d )",
			$product
		);
	}
}
