<?php
/**
 * Renewals
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Reports;

/**
 * Renewals
 *
 * @since 3.9.0
 */
class Renewals {

	/**
	 * The reports registry.
	 *
	 * @var \EDD\Reports\Data\Report_Registry
	 */
	private $reports;

	/**
	 * The report ID.
	 *
	 * @var string
	 */
	private $id = 'software_licensing_renewals';

	/**
	 * Registers the renewals data reports.
	 *
	 * @since 3.9.0
	 * @param \EDD\Reports\Data\Report_Registry $reports The reports registry.
	 * @return void
	 */
	public function __construct( $reports ) {
		$this->reports = $reports;

		try {
			$this->register_report();
		} catch ( \Exception $e ) {
			// Do nothing.
		}
	}

	/**
	 * Registers the activation data top level report.
	 *
	 * @since 3.9.0
	 */
	public function register_report() {
		$tiles  = $this->get_tiles();
		$charts = $this->get_charts();

		$this->reports->add_report(
			$this->id,
			array(
				'label'     => __( 'License Renewals', 'edd_sl' ),
				'icon'      => 'controls-repeat',
				'priority'  => 50,
				'endpoints' => array(
					'tiles'  => array_keys( $tiles ),
					'charts' => array_keys( $charts ),
				),
			)
		);
		foreach ( $tiles as $tile => $class ) {
			new $class( $this->reports );
		}
		foreach ( $charts as $chart => $class ) {
			new $class( $this->reports );
		}
	}

	/**
	 * Returns the tiles for the activation data report.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	private function get_tiles(): array {
		return array(
			'software_licensing_renewals_number'   => 'EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles\RenewalCounts',
			'software_licensing_renewals_earnings' => 'EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles\RenewalEarnings',
		);
	}

	/**
	 * Gets the charts for the activation data report.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	private function get_charts(): array {
		return array(
			'software_licensing_renewals_chart_earnings' => 'EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts\RenewalEarnings',
			'software_licensing_renewals_chart_counts'   => 'EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts\RenewalCounts',
		);
	}
}
