<?php
/**
 * Upgrade Earnings
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Tiles\Tile;
use EDD\Reports;

/**
 * Upgrade Earnings
 *
 * @since 3.9.0
 */
class UpgradeEarnings extends Tile {

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'software_licensing_upgrades_earnings';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'Upgrade Earnings', 'edd_sl' );
	}

	/**
	 * Gets the data for the endpoint.
	 *
	 * @since 3.9.0
	 * @return mixed
	 */
	protected function get_data() {
		global $wpdb;
		$column   = $this->exclude_taxes ? 'total - tax' : 'total';

		$earnings = $wpdb->get_var(
			"SELECT SUM({$column} / edd_o.rate) FROM {$wpdb->edd_orders} edd_o
			 INNER JOIN {$wpdb->edd_ordermeta} edd_ometa ON( edd_o.id = edd_ometa.edd_order_id )
			 WHERE edd_o.type = 'sale'
			 AND edd_ometa.meta_key = '_edd_sl_upgraded_payment_id'
			 AND edd_o.status IN( 'complete', 'revoked' )
			 AND {$this->get_date_sql()}"
		);

		if ( is_null( $earnings ) ) {
			$earnings = 0;
		}

		return edd_currency_filter( edd_format_amount( $earnings ) );
	}
}
