<?php
/**
 * Most Recent API Request
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Tiles\Tile;
use EDD\Reports;

/**
 * Most Recent API Request
 *
 * @since 3.9.0
 */
class RecentRequest extends Tile {
	use \EDD\SoftwareLicensing\Admin\Reports\Traits\Query;

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_most_recent_api_request';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'Active Licenses', 'edd_sl' );
	}

	/**
	 * Gets the data for the endpoint.
	 *
	 * @since 3.9.0
	 * @return mixed
	 */
	protected function get_data() {
		global $wpdb;
		$sql = "SELECT COUNT(*) FROM {$wpdb->prefix}edd_license_activations WHERE {$this->get_date_sql( 'last_request' )} {$this->get_product_sql_query()}";

		return $wpdb->get_var( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
	}
}
