<?php
/**
 * Renewal Counts
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Charts\Graph;
use EDD\Reports;

/**
 * Renewal Counts
 *
 * @since 3.9.0
 */
class RenewalCounts extends Graph {

	/**
	 * The key for the dataset.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $key = 'sales';

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'software_licensing_renewals_chart_counts';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'Number of Renewals', 'edd_sl' );
	}

	/**
	 * Gets the query results that will be used to build the chart.
	 *
	 * @since 3.9.0
	 * @return mixed
	 */
	protected function get_query_results(): array {
		global $wpdb;

		$statuses = edd_get_complete_order_statuses();

		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT COUNT(*) AS value, {$this->sql_clauses['select']}
				 FROM {$wpdb->edd_orders} edd_o
				 INNER JOIN {$wpdb->edd_ordermeta} edd_ometa ON( edd_o.id = edd_ometa.edd_order_id )
				 WHERE edd_o.type = 'sale'
				 AND edd_ometa.meta_key = '_edd_sl_is_renewal'
				 AND edd_o.status IN( '" . implode( "', '", $wpdb->_escape( $statuses ) ) . "' )
				 AND {$this->get_date_sql()} {$this->get_group_by()}"
			)
		);
	}
}
