<?php
/**
 * File Downloads Chart (Software Licensing Extension)
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Charts\FileDownloads as CoreFileDownloads;

/**
 * File Downloads Chart class (excluding package downloads)
 *
 * Extends the core FileDownloads chart to exclude software licensing package downloads.
 *
 * @since 3.9.0
 */
class FileDownloads extends CoreFileDownloads {
	use \EDD\SoftwareLicensing\Admin\Reports\Traits\Query;

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_file_downloads_chart';
	}

	/**
	 * Gets the query results for building the chart.
	 * Excludes package downloads (those with sl_package_download_license meta key).
	 *
	 * @since 3.9.0
	 * @return array
	 */
	protected function get_query_results(): array {
		global $wpdb;

		$download_data = $this->get_download_data();
		$product_id    = '';
		$price_id      = '';
		$date_sql      = $this->get_date_sql();

		if ( is_array( $download_data ) ) {
			$product_id = $wpdb->prepare( 'AND edd_lfd.product_id = %d', absint( $download_data['download_id'] ) );

			if ( isset( $download_data['price_id'] ) && is_numeric( $download_data['price_id'] ) ) {
				$price_id = $wpdb->prepare( 'AND edd_lfd.price_id = %d', absint( $download_data['price_id'] ) );
			}
		}

		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT COUNT(*) AS value, {$this->sql_clauses['select']}
				 FROM {$wpdb->edd_logs_file_downloads} edd_lfd
				 LEFT JOIN {$wpdb->edd_logs_file_downloadmeta} edd_lfd_meta
				 	ON edd_lfd.id = edd_lfd_meta.edd_logs_file_download_id
				 	AND edd_lfd_meta.meta_key = %s
				 WHERE edd_lfd_meta.meta_key IS NULL
				 AND ({$date_sql})
				 {$product_id} {$price_id}
				 {$this->get_group_by()}",
				'sl_package_download_license'
			)
		);
	}
}
