<?php
/**
 * Sections Class
 *
 * @package   EDD\SoftwareLicensing\Admin\Downloads\Editor
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Downloads\Editor;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Admin\Downloads\Editor\Sections as Base;

/**
 * Main class for creating a vertically tabbed UI
 *
 * @since 3.9.0
 */
class Sections extends Base {

	/**
	 * Section ID
	 *
	 * @since 3.9.0
	 *
	 * @var array
	 */
	protected $id = 'edd_sl_download_editor__';

	/**
	 * ID of the currently selected section
	 *
	 * @since 3.9.0
	 *
	 * @var string
	 */
	public $current_section = 'general';

	/**
	 * Is a section the current section?
	 *
	 * @since 3.9.0
	 * @param string $section_id The section ID to check.
	 * @return bool
	 */
	protected function is_current_section( $section_id = '' ) {
		return (bool) ( 'general' === $section_id );
	}
}
