<?php
/**
 * Deprecated functions.
 *
 * @package EDD_Software_Licensing
 * @since   3.8.12
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Disable core discounts on renewals, if enabled
 *
 * @since  3.5
 * @deprecated 3.8.12
 * @return void
 */
function edd_sl_remove_discounts_field() {
	if ( edd_get_option( 'edd_sl_disable_discounts', false ) && EDD()->session->get( 'edd_is_renewal' ) == '1' ) {
		remove_action( 'edd_checkout_form_top', 'edd_discount_field', -1 );
	}
}

/**
 * Prevent adding discounts through direct linking, if enabled
 *
 * @since  3.5
 * @deprecated 3.8.12
 * @return void
 */
function edd_sl_disable_url_discounts() {
	if ( edd_get_option( 'edd_sl_disable_discounts', false ) && EDD()->session->get( 'edd_is_renewal' ) == '1' ) {
		remove_action( 'init', 'edd_listen_for_cart_discount', 0 );
	}
}

/**
 * Remove existing discounts if renewal is set
 *
 * @since  3.5
 * @deprecated 3.8.12
 * @return void
 */
function edd_sl_remove_discounts() {
	if ( edd_get_option( 'edd_sl_disable_discounts', false ) && EDD()->session->get( 'edd_is_renewal' ) == '1' ) {
		add_filter( 'edd_cart_has_discounts', '__return_false' );
		edd_unset_all_cart_discounts();
	}
}

/**
 * Setup License Key Post Type
 *
 * Setup the License Log Post Type
 *
 * Registers the License Key CPT.
 *
 * @since       1.0
 * @deprecated 3.9.0
 * @return      void
 */
function edd_sl_setup_post_type() {

	register_post_type(
		'edd_license_log',
		array(
			'public'             => false,
			'publicly_queryable' => false,
			'show_ui'            => false,
			'query_var'          => false,
			'rewrite'            => false,
			'capability_type'    => 'page',
			'has_archive'        => false,
			'hierarchical'       => false,
			'supports'           => array( 'title', 'editor' ),
			'taxonomies'         => array( 'edd_log_type' ),
		)
	);

	if ( ! taxonomy_exists( 'edd_log_type' ) ) {
		register_taxonomy( 'edd_log_type', 'edd_license_log', array( 'public' => false ) );
	}
}

/**
 * Get the total number of renewals and earnings for a specific date
 *
 * @since unknown
 * @deprecated 3.7
 * @param int $day   The day of the month
 * @param int $month The month of the year
 * @param int $year  The year
 * @param int $hour  The hour of the day
 * @return array
 */
function edd_sl_get_renewals_by_date( $day = null, $month = null, $year = null, $hour = null ) {

	$args = apply_filters(
		'edd_get_renewals_by_date',
		array(
			'number'   => -1,
			'status'   => array( 'revoked', 'publish', 'complete' ),
			'meta_key' => '_edd_sl_is_renewal',
			'year'     => $year,
			'month'    => $month,
			'fields'   => 'ids',
		),
		$day,
		$month,
		$year
	);

	if ( ! empty( $day ) ) {
		$args['day'] = $day;
	}

	if ( ! empty( $hour ) ) {
		$args['hour'] = $hour;
	}

	$query    = new EDD_Payments_Query( $args );
	$renewals = $query->get_payments();

	$return             = array();
	$return['earnings'] = 0;
	$return['count']    = count( $renewals );
	if ( $renewals ) {
		foreach ( $renewals as $renewal ) {
			$return['earnings'] += edd_get_payment_amount( $renewal->ID );
		}
	}
	return $return;
}

/**
 * Sends all enabled renewal notices on a daily basis.
 *
 * @deprecated 3.9.0
 * @return void
 */
function edd_sl_scheduled_reminders() {

	$edd_sl_emails = new EDD_SL_Emails();

	$notices = edd_software_licensing()->notices->get_notices();

	foreach ( $notices as $notice ) {

		if ( ! edd_software_licensing()->notices->is_enabled( $notice ) ) {
			continue;
		}

		$send_period = edd_software_licensing()->notices->get_notice_period( $notice );
		// Expired notices are triggered from the set_license_status() method of EDD_Software_Licensing.
		if ( 'expired' === $send_period ) {
			continue;
		}

		$keys = edd_sl_get_expiring_licenses( $send_period );
		if ( ! $keys ) {
			continue;
		}

		$notice_id = edd_software_licensing()->notices->get_notice_id( $notice );
		foreach ( $keys as $license_id ) {

			if ( ! apply_filters( 'edd_sl_send_scheduled_reminder_for_license', true, $license_id, $notice_id ) ) {
				continue;
			}

			$license = edd_software_licensing()->get_license( $license_id );

			if ( false === $license ) {
				continue;
			}

			// Sanity check to ensure we don't send renewal notices to people with lifetime licenses.
			if ( $license->is_lifetime ) {
				continue;
			}

			$sent_time = $license->get_meta( sanitize_key( '_edd_sl_renewal_sent_' . $send_period ) );
			if ( $sent_time ) {

				$expire_date = strtotime( $send_period, $sent_time );

				if ( current_time( 'timestamp' ) < $expire_date ) {

					// The renewal period isn't expired yet so don't send again.
					continue;

				}

				$license->delete_meta( sanitize_key( '_edd_sl_renewal_sent_' . $send_period ) );

			}

			$edd_sl_emails->send_renewal_reminder( $license->ID, $notice_id );
		}
	}
}

/**
 * Return licenses that expire on the day determined by the period provided.
 *
 * This does not get all licenses between now and the period, but on the day, in the past or future for the period.
 *
 * Example:
 * A period of +1month will get all licenses that expire on the date 30 days from now.
 * A period of -1day will get all licenses that expired yesterday
 *
 * If you want all licenses that expired in a range, you can use the EDD_SL_License_DB class with the following arguments
 * 'expiration' => array(
 *     'start' => <unix timestamp of start date>,
 *     'end'   => <unix timestamp of end date>,
 * )
 *
 * @deprecated 3.9.0
 * @param string $period This is a PHP pseudo-date string used with `strototime` and can be provided values like
 *                       +1month (default), +2weeks, +1day, +1year, and also supports negative values to look backwards.
 *
 * @return array|bool    If found, it will return an array of license IDs, if none are found, it returns false.
 */
function edd_sl_get_expiring_licenses( $period = '+1month' ) {

	$args = array(
		'number'     => - 1,
		'fields'     => 'ids',
		'parent'     => 0,
		'expiration' => array(
			'start' => strtotime( $period . ' midnight', current_time( 'timestamp' ) ),
			'end'   => strtotime( $period . ' midnight', current_time( 'timestamp' ) ) + ( DAY_IN_SECONDS - 1 ),
		),
	);

	$args = apply_filters( 'edd_sl_expiring_licenses_args', $args );
	$keys = edd_software_licensing()->licenses_db->get_licenses( $args );

	if ( ! $keys ) {
		return false; // no expiring keys found
	}

	return $keys;
}

/**
 * Check for expired licenses.
 *
 * @deprecated 3.9.0
 * @return void|bool
 */
function edd_sl_check_for_expired_licenses() {

	$args = array(
		'number'     => -1,
		'parent'     => 0, // Child keys get expired during set_license_status()
		'expiration' => array(
			'start' => strtotime( '-1 Month' ),
			'end'   => current_time( 'timestamp' ),
		),
		'status'     => array( 'active', 'inactive', 'disabled' ),
	);

	$args     = apply_filters( 'edd_sl_expired_licenses_args', $args );
	$licenses = edd_software_licensing()->licenses_db->get_licenses( $args );

	if ( ! $licenses ) {
		return; // no expiring keys found
	}

	foreach ( $licenses as $license ) {
		$license->status = 'expired';
	}
}

/**
 * Checks if the EDD core Email Templates are registered.
 *
 * @since 3.8.12
 * @deprecated 3.9.0
 * @return bool True if the email templates are registered, false otherwise.
 */
function edd_sl_are_email_templates_registered() {
	return (bool) class_exists( '\\EDD\\Emails\\Email' );
}

/**
 * Controls display of dynamic strings on renewal notice form
 *
 * @since 3.5
 * @deprecated 3.9.0
 */
function edd_sl_output_dynamic_email_strings() {}

/**
 * Registers the SL email settings under the emails tab.
 *
 * @since 3.8.5
 * @deprecated 3.9.0
 * @param array $settings The existing plugin settings.
 * @return array
 */
function edd_sl_renewal_notices_settings_array( $settings ) {
	return $settings;
}

/**
 * Displays the renewal notices options
 *
 * @since 3.0
 * @deprecated 3.9.0
 * @param array $args The option arguments.
 * @return void
 */
function edd_sl_renewal_notices_settings( $args ) {

	$notices = edd_sl_get_renewal_notices();
	// echo '<pre>'; print_r( $notices ); echo '</pre>';
	ob_start(); ?>
	<table id="edd_sl_renewal_notices" class="wp-list-table widefat fixed posts">
		<thead>
			<tr>
				<th class="edd-sl-renewal-subject-col" scope="col"><?php _e( 'Subject', 'edd_sl' ); ?></th>
				<th class="edd-sl-renewal-period-col" scope="col"><?php _e( 'Send Period', 'edd_sl' ); ?></th>
				<th scope="col"><?php _e( 'Actions', 'edd_sl' ); ?></th>
			</tr>
		</thead>
		<?php
		if ( ! empty( $notices ) ) :
			$i = 1;
			?>
			<?php
			foreach ( $notices as $key => $notice ) :
				$notice = edd_sl_get_renewal_notice( $key );
				?>
			<tr
				<?php
				if ( $i % 2 == 0 ) {
					echo 'class="alternate"'; }
				?>
			>
				<td><?php echo esc_html( stripslashes( $notice['subject'] ) ); ?></td>
				<td><?php echo esc_html( edd_sl_get_renewal_notice_period_label( $key ) ); ?></td>
				<td>
					<?php
					$actions = array(
						'edit'    => array(
							'url'   => add_query_arg(
								array(
									'post_type'     => 'download',
									'page'          => 'edd-license-renewal-notice',
									'edd_sl_action' => 'edit-renewal-notice',
									'notice'        => urlencode( $key ),
								),
								admin_url( 'edit.php' )
							),
							'label' => __( 'Edit', 'edd_sl' ),
							'class' => 'edd-sl-edit-renewal-notice',
						),
						'clone'   => array(
							'url'   => wp_nonce_url(
								add_query_arg(
									array(
										'edd-action' => 'clone_renewal_notice',
										'notice-id'  => urlencode( $key ),
									)
								)
							),
							'label' => __( 'Clone', 'edd_sl' ),
							'class' => 'edd-sl-clone-renewal-notice',
						),
						'preview' => array(
							'url'   => wp_nonce_url(
								add_query_arg(
									array(
										'edd-action' => 'edd_sl_preview_notice',
										'notice-id'  => urlencode( $key ),
									),
									home_url()
								)
							),
							'label' => __( 'Preview', 'edd_sl' ),
							'class' => 'edd-sl-preview-renewal-notice',
						),
						'delete'  => array(
							'url'   => wp_nonce_url(
								add_query_arg(
									array(
										'edd-action' => 'delete_renewal_notice',
										'notice-id'  => urlencode( $key ),
									)
								)
							),
							'label' => __( 'Delete', 'edd_sl' ),
							'class' => 'edd-delete',
						),
					);
					$output  = array();
					foreach ( $actions as $key => $action ) {
						$output[] = sprintf(
							'<a href="%1$s" class="%2$s" data-key="%3$s" %5$s>%4$s</a>',
							esc_url( $action['url'] ),
							esc_attr( $action['class'] ),
							esc_attr( $key ),
							esc_html( $action['label'] ),
							'preview' === $key ? 'target="_blank"' : ''
						);
					}
					echo wp_kses_post( implode( ' | ', $output ) );
					?>
				</td>
			</tr>
				<?php
				++$i;
endforeach;
			?>
		<?php endif; ?>
	</table>
	<p>
		<a href="<?php echo esc_url( admin_url( 'edit.php?post_type=download&page=edd-license-renewal-notice&edd_sl_action=add-renewal-notice' ) ); ?>" class="button-secondary" id="edd_sl_add_renewal_notice"><?php _e( 'Add Renewal Notice', 'edd_sl' ); ?></a>
	</p>
	<?php
	echo ob_get_clean();
}

/**
 * Renders the add / edit renewal notice screen
 *
 * @since 3.0
 * @deprecated 3.9.0
 * @param array $input The value inputted in the field
 * @return string $input Sanitizied value
 */
function edd_sl_license_renewal_notice_edit() {

	$action = isset( $_GET['edd_sl_action'] ) ? sanitize_text_field( $_GET['edd_sl_action'] ) : 'add-renewal-notice';
	if ( ! in_array( $action, array( 'add-renewal-notice', 'edit-renewal-notice' ), true ) ) {
		return;
	}
	if ( 'edit-renewal-notice' === $action ) {
		include EDD_SL_PLUGIN_DIR . 'includes/admin/edit-renewal-notice.php';
	} else {
		include EDD_SL_PLUGIN_DIR . 'includes/admin/add-renewal-notice.php';
	}
}

/**
 * Processes cloning an existing renewal notice
 *
 * @since 3.5
 * @deprecated 3.9.0
 * @return void
 */
function edd_sl_process_clone_renewal_notice() {

	if ( ! is_admin() || ! isset( $_GET['notice-id'] ) ) {
		return;
	}

	if ( ! wp_verify_nonce( $_GET['_wpnonce'] ) ) {
		wp_die( __( 'Nonce verification failed', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	if ( ! current_user_can( 'manage_shop_settings' ) ) {
		wp_die( __( 'You do not have permission to add renewal notices', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	$data = edd_sl_get_renewal_notice( absint( $_GET['notice-id'] ) );

	$notices = edd_sl_get_renewal_notices();
	$key     = is_array( $notices ) ? count( $notices ) : 1;

	$notices[] = array(
		'subject'     => $data['subject'] . ' - ' . __( 'Copy', 'edd_sl' ),
		'message'     => $data['message'],
		'send_period' => $data['send_period'],
	);

	update_option( 'edd_sl_renewal_notices', $notices );

	$redirect_url = add_query_arg(
		array(
			'post_type'     => 'download',
			'page'          => 'edd-license-renewal-notice',
			'edd_sl_action' => 'edit-renewal-notice',
			'notice'        => urlencode( $key ),
			'edd-message'   => urlencode( __( 'Renewal Notice cloned successfully. You are editing a new notice.', 'edd_sl' ) ),
			'edd-result'    => 'success',
		),
		admin_url( 'edit.php' )
	);

	wp_safe_redirect( $redirect_url );
	exit;
}

/**
 * Processes the creation of a new renewal notice
 *
 * @since 3.0
 * @deprecated 3.9.0
 * @param array $data The post data
 * @return void
 */
function edd_sl_process_add_renewal_notice( $data ) {

	if ( ! is_admin() ) {
		return;
	}

	if ( ! current_user_can( 'manage_shop_settings' ) ) {
		wp_die( __( 'You do not have permission to add renewal notices', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	if ( ! wp_verify_nonce( $data['edd-renewal-notice-nonce'], 'edd_renewal_nonce' ) ) {
		wp_die( __( 'Nonce verification failed', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	$subject = isset( $data['subject'] ) ? sanitize_text_field( $data['subject'] ) : __( 'Your License Key is About to Expire', 'edd_sl' );
	$period  = isset( $data['period'] ) ? sanitize_text_field( $data['period'] ) : '+1month';
	$message = isset( $data['message'] ) ? wp_kses( stripslashes( $data['message'] ), wp_kses_allowed_html( 'post' ) ) : false;
	$result  = 'success';
	$notice  = __( 'Renewal Notice saved successfully.', 'edd_sl' );

	if ( empty( $message ) ) {
		$result  = 'warning';
		$notice  = __( 'Your message was empty and could not be saved. It has been reset to the default.', 'edd_sl' );
		$message = edd_sl_get_default_renewal_notice_message();
	}

	$notices     = edd_sl_get_renewal_notices();
	$key         = is_array( $notices ) ? count( $notices ) : 1;
	$notice_data = array(
		'subject'     => $subject,
		'message'     => $message,
		'send_period' => $period,
	);
	if ( isset( $data['status'] ) ) {
		$notice_data['enabled'] = (bool) $data['status'];
	}

	$notices[] = $notice_data;

	update_option( 'edd_sl_renewal_notices', $notices );

	$redirect_url = add_query_arg(
		array(
			'post_type'     => 'download',
			'page'          => 'edd-license-renewal-notice',
			'edd_sl_action' => 'edit-renewal-notice',
			'notice'        => urlencode( $key ),
			'edd-message'   => urlencode( $notice ),
			'edd-result'    => urlencode( $result ),
		),
		admin_url( 'edit.php' )
	);

	wp_safe_redirect( $redirect_url );
	exit;
}

/**
 * Processes the update of an existing renewal notice
 *
 * @since 3.0
 * @deprecated 3.9.0
 * @param array $data The post data
 * @return void
 */
function edd_sl_process_update_renewal_notice( $data ) {

	if ( ! is_admin() ) {
		return;
	}

	if ( ! current_user_can( 'manage_shop_settings' ) ) {
		wp_die( __( 'You do not have permission to add renewal notices', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	if ( ! wp_verify_nonce( $data['edd-renewal-notice-nonce'], 'edd_renewal_nonce' ) ) {
		wp_die( __( 'Nonce verification failed', 'edd_sl' ), __( 'Error', 'edd_sl' ), array( 'response' => 401 ) );
	}

	if ( ! isset( $data['notice-id'] ) ) {
		wp_die( __( 'No renewal notice ID was provided', 'edd_sl' ) );
	}

	$subject = isset( $data['subject'] ) ? sanitize_text_field( $data['subject'] ) : __( 'Your License Key is About to Expire', 'edd_sl' );
	$period  = isset( $data['period'] ) ? sanitize_text_field( $data['period'] ) : '1month';
	$message = isset( $data['message'] ) ? wp_kses( stripslashes( $data['message'] ), wp_kses_allowed_html( 'post' ) ) : false;
	$result  = 'success';
	$notice  = __( 'Renewal Notice saved successfully.', 'edd_sl' );

	if ( empty( $message ) ) {
		$result  = 'warning';
		$notice  = __( 'Your message was empty and could not be saved. It has been reset to the default.', 'edd_sl' );
		$message = edd_sl_get_default_renewal_notice_message();
	}

	$notices                                 = edd_sl_get_renewal_notices();
	$notices[ absint( $data['notice-id'] ) ] = array(
		'subject'     => $subject,
		'message'     => $message,
		'send_period' => $period,
	);
	if ( isset( $data['status'] ) ) {
		$notices[ absint( $data['notice-id'] ) ]['enabled'] = (bool) $data['status'];
	}

	update_option( 'edd_sl_renewal_notices', $notices );

	$redirect_url = add_query_arg(
		array(
			'post_type'     => 'download',
			'page'          => 'edd-license-renewal-notice',
			'edd_sl_action' => 'edit-renewal-notice',
			'notice'        => urlencode( $data['notice-id'] ),
			'edd-message'   => urlencode( $notice ),
			'edd-result'    => urlencode( $result ),
		),
		admin_url( 'edit.php' )
	);

	wp_safe_redirect( $redirect_url );
	exit;
}
