<?php

if ( ! current_user_can( 'view_licenses' ) ) {
	return;
}

if ( $order_or_order_id instanceof \EDD\Orders\Order ) {
	$order = $order_or_order_id;
} else {
	$order = edd_get_order( $order_or_order_id );
}

if ( empty( $order->id ) ) {
	return;
}

$order_licenses = edd_software_licensing()->get_licenses_of_purchase( $order->id );
$child_licenses = array();
$licenses       = array();

if ( ! empty( $order_licenses ) ) {
	// Split child licenses from the main array
	foreach ( $order_licenses as $key => $license ) {
		if ( $license->parent ) {
			$child_licenses[] = $license;
			unset( $order_licenses[ $key ] );
		}
	}

	foreach ( $order_licenses as $key => $license ) {
		$licenses[] = $license;
		unset( $order_licenses[ $key ] );

		if ( is_array( $child_licenses ) && count( $child_licenses ) > 0 ) {
			foreach ( $child_licenses as $child_key => $child ) {
				if ( (int) $child->parent === (int) $license->ID ) {
					$licenses[] = $child;
					unset( $child_licenses[ $child_key ] );
				}
			}
		}
	}
}

?>
<div>
	<div class="order-licenses">
		<?php if ( $licenses ) : ?>
			<table class="wp-list-table widefat striped">
				<thead>
					<th class="name column-name"><?php esc_html_e( 'Product', 'edd_sl' ); ?></th>
					<th class="price column-key"><?php esc_html_e( 'License', 'edd_sl' ); ?></th>
				</thead>
				<tbody>
					<?php
					foreach ( $licenses as $key => $license ) :
						$key            = $license->key;
						$status         = edd_software_licensing()->get_license_status( $license->ID );
						$status_display = '<span class="edd-sl-' . esc_attr( $status ) . '">' . esc_html( $status ) . '</span>';
						?>
						<tr>
							<td class="column-primary">
								<?php
								if ( $license->parent ) {
									echo '&#8212; ';
								}

								printf(
									'<div class="row-title"><a href="%1$s">%2$s</div>',
									esc_url(
										edd_get_admin_url(
											array(
												'page' => 'edd-licenses',
												'view' => 'overview',
												'license_id' => absint( $license->ID ),
											)
										)
									),
									esc_html( $license->get_download()->get_name() )
								);
								?>
							</td>
							<td class="price column-key">
								<code><?php echo esc_html( $key ); ?></code> &ndash; <?php echo wp_kses_post( $status_display ); ?>
							</td>
						</tr>
						<?php
					endforeach;
					?>
				</tbody>
			</table>
		<?php endif; ?>
		<?php if ( current_user_can( 'manage_licenses' ) ) : ?>
			<div>
				<p><?php esc_html_e( 'Missing license keys for this purchase? Use the Missing Licenses tool to create them.', 'edd_sl' ); ?></p>
				<div id="edd-retroactive-processor" class="edd-export-form edd-import-export-form">
					<?php
					wp_enqueue_script( 'edd-admin-tools-export' );
					wp_nonce_field( 'edd_ajax_export', 'edd_ajax_export' );
					?>
					<input type="hidden" name="edd-export-class" value="EDD\SoftwareLicensing\Admin\Exports\Retroactive">
					<input type="hidden" name="order_id" value="<?php echo esc_attr( $order->id ); ?>">
					<button type="button" class="button button-secondary"><?php esc_html_e( 'Process Licenses', 'edd_sl' ); ?></button>
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>
