<?php
$license_id = $license->ID;

do_action( 'edd_sl_license_before_license_logs', $license->key );
?>

<div class="edd-item-info license-logs">
	<h3>
		<?php esc_html_e( 'Logged Entries:', 'edd_sl' ); ?>
		<span alt="f223" class="edd-help-tip dashicons dashicons-editor-help" title="<?php _e( 'This table shows log entries relevant to this license.', 'edd_sl' ); ?>"></span>
	</h3>
	<table class="wp-list-table widefat striped license-logs">
		<thead>
			<tr>
				<th><?php esc_html_e( 'ID', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Date/Time', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Entry', 'edd_sl' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			$logs = $license->get_logs();

			if ( ! empty( $logs ) ) {
				foreach ( $logs as $log ) {
					echo '<tr>';
					echo '<td>#' . esc_html( $log->ID ) . '</td>';
					echo '<td>' . edd_date_i18n( strtotime( $log->date_created ), 'Y-m-d h:i:s' ) . '</td>';
					echo '<td>';
					$data = json_decode( $log->content );
					echo esc_html( $log->subject ) . '<br />';

					if ( isset( $data->HTTP_USER_AGENT ) ) {
						echo esc_html( $data->HTTP_USER_AGENT ) . ' - ';
					}

					if ( isset( $data->HTTP_USER_AGENT ) ) {
						echo 'IP: ' . esc_html( $data->REMOTE_ADDR ) . ' - ';
					}

					if ( isset( $data->HTTP_USER_AGENT ) ) {
						echo esc_html( date_i18n( get_option( 'date_format' ), $data->REQUEST_TIME ) . ' ' . date_i18n( get_option( 'time_format' ), $data->REQUEST_TIME ) );
					}

					if ( isset( $data->license_key ) ) {
						echo esc_html( $data->license_key ) . ' - ';
					}

					if ( isset( $data->user_id ) ) {
						$login = '';
						if ( ! empty( $data->user_id ) ) {
							$user  = new WP_User( $data->user_id );
							$login = $user->user_login;
						}

						if ( ! empty( $login ) ) {
							echo esc_html( $login );
						}
					}
					echo '</td>';
					echo '</tr>';
				}
			} else {
				echo '<tr><td colspan="3">' . esc_html__( 'This license has no log entries.', 'edd_sl' ) . '</td></tr>';
			}
			?>
		</tbody>
	</table>

	<?php do_action( 'edd_sl_license_after_license_logs', $license->key ); ?>

</div>
