<?php
$render = true;

if ( ! current_user_can( 'view_licenses' ) ) {
	edd_set_error( 'edd-no-access', __( 'You are not permitted to view this data.', 'edd_sl' ) );
	$render = false;
}

if ( isset( $_GET['license'] ) ) {
	if ( is_numeric( $_GET['license'] ) ) {
		$new_license_id = edd_software_licensing()->license_meta_db->get_license_id( '_edd_sl_legacy_id', absint( $_GET['license'] ), true );
	}

	if ( empty( $new_license_id ) ) {
		edd_set_error( 'edd-invalid-license', __( 'Invalid license ID provided.', 'edd_sl' ) );
		$render = false;
	}
}

if ( ( ! isset( $_GET['license_id'] ) || ! is_numeric( $_GET['license_id'] ) ) && empty( $new_license_id ) ) {
	edd_set_error( 'edd-invalid-license', __( 'Invalid license ID provided.', 'edd_sl' ) );
	$render = false;
}

$license_id = isset( $_GET['license_id'] ) ? absint( $_GET['license_id'] ) : $new_license_id;
$license    = edd_software_licensing()->get_license( $license_id );

if ( false === $license ) {
	edd_set_error( 'edd-invalid-license', __( 'Invalid license ID provided.', 'edd_sl' ) );
	$render = false;
}

if ( ! $render ) {
	if ( edd_get_errors() ) : ?>
		<div class="error settings-error">
			<?php edd_print_errors(); ?>
		</div>
		<?php
	endif;
	return;
}

$license_tabs = edd_sl_license_tabs();
?>
<div class="edd-editor__header">
	<div class="edd-editor__header--actions">
		<h2>
			<?php
			if ( 'delete' !== $view && array_key_exists( $view, $license_tabs ) && ! empty( $license_tabs[ $view ]['title'] ) ) {
				printf(
					/* translators: 1: License Tab Title, 2: License Key */
					esc_html__( 'License %1$s: %2$s', 'edd_sl' ),
					esc_html( $license_tabs[ $view ]['title'] ),
					esc_html( $license->key )
				);
			} else {
				/* translators: %s: License Key */
				printf( esc_html__( 'Manage License: %s', 'edd_sl' ), esc_html( $license->key ) );
			}
			?>
		</h2>
	</div>
</div>
<div class="wrap">
	<h2><?php esc_html_e( 'Manage License Details', 'edd_sl' ); ?></h2>

	<?php if ( $license->key ) : ?>

		<div id="edd-item-wrapper" class="edd-item-has-tabs edd-clearfix edd-vertical-sections">
			<ul id="edd-item-tab-wrapper" class="license-tab-wrapper-list section-nav">
				<?php foreach ( $license_tabs as $key => $tab ) : ?>
					<?php
					$active = $key === $view;
					$class  = $active ? 'section-title section-title--is-active' : 'section-title';
					?>

					<li class="<?php echo esc_attr( $class ); ?>">

						<?php
						// edd item tab full title
						$tab_title = sprintf( _x( 'License %s', 'License Details page tab title', 'edd_sl' ), esc_attr( $tab['title'] ) );

						// aria-label output
						$aria_label = ' aria-label="' . $tab_title . '"';
						$url        = edd_get_admin_url(
							array(
								'page'       => 'edd-licenses',
								'view'       => $key,
								'license_id' => $license->ID,
							)
						);
						if ( $active ) {
							$url = '';
						}
						?>

						<a href="<?php echo $url ? esc_url( $url ) : ''; ?>"<?php echo $aria_label; ?>>
						<span class="dashicons <?php echo sanitize_html_class( $tab['dashicon'] ); ?>" aria-hidden="true"></span>
						<?php
						echo '<span class="edd-item-tab-label">' . esc_attr( $tab['title'] ) . '</span>';
						?>
						</a>
					</li>

				<?php endforeach; ?>
			</ul>

			<div id="edd-item-card-wrapper" class="section-wrap">
				<div class="section-content">
					<?php
					if ( is_callable( $callbacks[ $view ] ) ) {
						$callbacks[ $view ]( $license );
					}
					?>
				</div>
			</div>

		</div>
	<?php endif; ?>
</div>
