<div class="edd-item-info license-downloads">
	<h3><?php esc_html_e( 'Logged Downloads', 'edd_sl' ); ?></h3>
	<p>
		<?php esc_html_e( 'These file downloads are logged by the Software Licensing API.', 'edd_sl' ); ?>
	</p>
	<table class="widefat striped">
		<thead>
			<tr>
				<th><?php esc_html_e( 'ID', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Download', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'IP Address', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'User Agent', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Date', 'edd_sl' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			$logs = edd_get_file_download_logs(
				array(
					'meta_query' => array(
						array(
							'key'     => 'sl_package_download_license',
							'value'   => $license->id,
							'compare' => '=',
						),
					),
					'number'     => 100,
					'orderby'    => 'date_created',
					'order'      => 'DESC',
				)
			);
			if ( empty( $logs ) ) {
				?>
				<tr>
					<td colspan="5"><?php esc_html_e( 'No downloads found.', 'edd_sl' ); ?></td>
				</tr>
				<?php
			} else {
				foreach ( $logs as $log ) {
					?>
					<tr class="license-download">
						<td><?php echo esc_html( $log->id ); ?></td>
						<td><?php echo esc_html( edd_get_download_name( $log->product_id ) ); ?></td>
						<td><?php echo esc_html( $log->ip ); ?></td>
						<td><?php echo esc_html( $log->user_agent ); ?></td>
						<td><?php echo esc_html( edd_date_i18n( strtotime( $log->date_created ), 'Y-m-d h:m:s' ) ); ?></td>
					</tr>
					<?php
				}
			}
			?>
		</tbody>
	</table>
</div>
