<?php

$license_id = $license->ID;
?>

<div class="license-logs-header">
	<span><?php printf( __( 'License Key: %s', 'edd_sl' ), $license->key ); ?></span>
</div>

<?php do_action( 'edd_sl_license_before_license_delete', $license->key ); ?>

<form id="delete-license" method="post" action="<?php echo admin_url( 'edit.php?post_type=download&page=edd-licenses&view=delete&license_id=' . $license->ID ); ?>">
	<div class="edd-item-info delete-license">
		<span class="delete-license-options">
			<p>
				<?php echo EDD()->html->checkbox( array( 'name' => 'edd-sl-license-delete-confirm' ) ); ?>
				<label for="edd-sl-license-delete-confirm"><?php _e( 'Are you sure you want to delete this license?', 'edd_sl' ); ?></label>
			</p>

			<?php do_action( 'edd_sl_license_delete_inputs', $license ); ?>
		</span>

		<span id="license-edit-actions">
			<input type="hidden" name="license_id" value="<?php echo $license->ID; ?>" />
			<?php wp_nonce_field( 'delete-license', '_wpnonce', false, true ); ?>
			<input type="hidden" name="edd_action" value="sl_delete_license" />
			<input type="submit" disabled="disabled" id="edd-sl-delete-license" class="button-primary" value="<?php _e( 'Delete License', 'edd_sl' ); ?>" />
			<a id="edd-sl-delete-license-cancel" href="<?php echo admin_url( 'edit.php?post_type=download&page=edd-licenses&view=overview&license_id=' . $license->ID ); ?>" class="delete"><?php _e( 'Cancel', 'edd_sl' ); ?></a>
		</span>
	</div>
</form>

<?php
do_action( 'edd_sl_license_after_license_delete', $license->key );
