<?php
/**
 * Render the individual upgrade path rows.
 * Approach and markup borrowed from edd_render_price_row().
 *
 * @param int   $key     The array key associated with the row.
 * @param array $args    The array of args needed to build the row.
 * @param int   $index   The index of the current row.
 *
 * @since 3.7
 * @since 3.9.0 The rendering is now part of the metabox view file.
 * @return void
 */
function edd_sl_render_upgrade_row( $key, $args, $index ) {
	$defaults = array(
		'download_id' => '',
		'discount'    => '',
		'price_id'    => '',
		'prorated'    => false,
	);

	$args  = wp_parse_args( $args, $defaults );
	$key   = $key;
	$index = $index;

	include EDD_SL_PLUGIN_DIR . 'includes/admin/views/html-metabox-upgrades-row.php';
}
add_action( 'edd_sl_render_upgrade_row', 'edd_sl_render_upgrade_row', 10, 4 );

/**
 * Disable "Software Licensing Settings" section in Advanced Settings view for Variable Pricing.
 *
 * @since 3.7
 *
 * @param int   $download_id Download ID.
 * @param int   $price_id    Price ID.
 * @param array $args        Custom parameters.
 */
function edd_sl_licensing_price_section( $download_id, $price_id, $args ) {
	$limit       = edd_software_licensing()->get_price_activation_limit( $download_id, $price_id );
	$is_lifetime = edd_software_licensing()->get_price_is_lifetime( $download_id, $price_id );
	?>
	<div class="edd-custom-price-option-section edd-custom-price-option-section--software-licensing" data-edd-requires-licensing="true">
		<span class="edd-custom-price-option-section-title"><?php esc_html_e( 'Software Licensing Settings', 'edd_sl' ); ?></span>
		<div class="edd-custom-price-option-section-content edd-form-row">
			<div class="edd-form-group edd-form-row__column">
				<label for="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][license_limit]">
					<?php
					esc_html_e( 'Activation Limit', 'edd_sl' );
					$tooltip = new EDD\HTML\Tooltip(
						array(
							'title'   => __( 'Activation Limit', 'edd_sl' ),
							'content' => __( 'For each variable pricing option, set the number of activations allowed per license. Use 0 or leave empty for unlimited. If your product is a bundle, the activation limits set here will override the activation limits set on the individual products.', 'edd_sl' ),
						)
					);
					$tooltip->output();
					?>
					</label>
				<div class="edd-form-group__control">
					<input class="edd-form-group__input small-text" type="number" min="0" step="1" name="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][license_limit]" id="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][license_limit]" value="<?php echo false !== $limit ? absint( $limit ) : ''; ?>">
				</div>
			</div>

			<div class="edd-form-group edd-form-row__column">
				<div class="edd-form-group__control edd-toggle">
					<input class="edd-form-group__input" <?php checked( true, $is_lifetime, true ); ?> type="checkbox" name="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][is_lifetime]" id="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][is_lifetime]" value="1">
					<label for="edd_variable_prices[<?php echo esc_attr( $price_id ); ?>][is_lifetime]">
						<?php
						esc_html_e( 'Lifetime', 'edd_sl' );
						$tooltip = new EDD\HTML\Tooltip(
							array(
								'title'   => __( 'Lifetime', 'edd_sl' ),
								'content' => __( 'Check this setting to provide licenses that never expire.', 'edd_sl' ),
							)
						);
						$tooltip->output();
						?>
					</label>
				</div>
			</div>
		</div>
	</div>
	<?php
}
add_action( 'edd_download_price_option_row', 'edd_sl_licensing_price_section', 800, 3 );

/**
 * Display the license keys associated with a purchase on the View Order Details screen
 *
 * @since 1.9
 * @param EDD\Orders\Order|int $order_or_order_id Order object or ID.
 */
function edd_sl_payment_details_meta_box( $order_or_order_id = 0 ) {
	require_once 'views/order-keys.php';
}

/**
 * Adds a section for order subscriptions to EDD 3.0.
 *
 * @since 2.12.0
 * @param array     $sections
 * @param EDD_Order $order
 * @return array
 */
function edd_sl_licenses_section( $sections, $order ) {
	if ( edd_is_add_order_page() ) {
		return $sections;
	}
	$has_licenses = edd_software_licensing()->get_licenses_of_purchase( $order->id );
	if ( empty( $has_licenses ) ) {
		$args = array(
			'post_type' => 'download',
			'nopaging'  => true,
			'fields'    => 'ids',
			'meta_key'  => '_edd_sl_enabled',
			'value'     => '1',
		);

		$licensed_products = get_posts( $args );
		if ( ! empty( $licensed_products ) ) {
			$has_licenses = edd_get_order_items(
				array(
					'order_id'       => $order->id,
					'product_id__in' => $licensed_products,
				)
			);
		}
	}
	if ( ! empty( $has_licenses ) ) {
		$sections[] = array(
			'id'       => 'licenses',
			'label'    => __( 'Licenses', 'edd_sl' ),
			'icon'     => 'lock',
			'callback' => 'edd_sl_payment_details_meta_box',
		);
	}

	return $sections;
}
add_filter( 'edd_get_order_details_sections', 'edd_sl_licenses_section', 10, 2 );
