<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Forces the Cache-Control header on our license views in admin to send the no-store header
 * which prevents the back-forward cache (bfcache) from storing a copy of this page in local
 * cache. This helps make sure that page elements modified via AJAX and DOM manipulations aren't
 * incorrectly shown as if they never changed.
 *
 * See: https://github.com/easydigitaldownloads/EDD-Software-Licensing/issues/1346#issuecomment-382159918
 *
 * @since 3.6.1
 * @param array $headers An array of nocache headers.
 *
 * @return array
 */
function _edd_sl_bfcache_buster( $headers ) {
	if ( ! is_admin() ) {
		return $headers;
	}

	$post_type = isset( $_GET['post_type'] ) ? strtolower( $_GET['post_type'] ) : false;
	$page      = isset( $_GET['page'] ) ? strtolower( $_GET['page'] ) : false;

	if ( false === $post_type || false === $page ) {
		return $headers;
	}

	if ( 'download' === $post_type && 'edd-licenses' === $page ) {
		$headers['Cache-Control'] = 'no-cache, must-revalidate, max-age=0, no-store';
	}

	return $headers;
}
add_filter( 'nocache_headers', '_edd_sl_bfcache_buster', 10, 1 );
