<?php
/**
 * Plugin Name: Easy Digital Downloads - Software Licensing
 * Plugin URI: https://easydigitaldownloads.com/downloads/software-licensing/
 * Description: Adds a software licensing system to Easy Digital Downloads.
 * Version: 3.9.0
 * Requires PHP: 7.4
 * Requires at least: 6.2
 * Author: Easy Digital Downloads
 * Author URI: https://easydigitaldownloads.com/
 * Contributors: easydigitaldownloads, cklosows, mordauk, littlerchicken
 * Text Domain: edd_sl
 * Domain Path: languages
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! defined( 'EDD_SL_PLUGIN_DIR' ) ) {
	define( 'EDD_SL_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'EDD_SL_PLUGIN_URL' ) ) {
	define( 'EDD_SL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'EDD_SL_PLUGIN_FILE' ) ) {
	define( 'EDD_SL_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'EDD_SL_VERSION' ) ) {
	define( 'EDD_SL_VERSION', '3.9.0' );
}

require_once EDD_SL_PLUGIN_DIR . 'vendor/autoload.php';

class_alias( EDD\SoftwareLicensing\Requirements\Requirements::class, 'EDD_SL_Requirements' );
class_alias( EDD\SoftwareLicensing\Requirements\Check::class, 'EDD_SL_Requirements_Check' );
/**
 * Run the requirements check.
 *
 * This needs to be delayed until `plugins_loaded`, otherwise we won't be able to detect
 * EDD install/version.
 */
add_action(
	'plugins_loaded',
	function () {
		$requirements_checker = new EDD\SoftwareLicensing\Requirements\Check( EDD_SL_PLUGIN_FILE );
		$requirements_checker->maybe_load();
	}
);

/**
 * Adds an option flag if the installation has not yet run, to designate that we
 * should run it later. The reason we do this is because when installation happens
 * the requirements haven't yet been checked, and we only actually want to run the
 * full installation once we have.
 *
 * @see edd_sl_install()
 */
register_activation_hook(
	EDD_SL_PLUGIN_FILE,
	function () {
		$current_version = get_option( 'edd_sl_version' );
		if ( ! $current_version ) {
			update_option( 'edd_sl_run_install', time() );
		}

		update_option( 'edd_sl_version', EDD_SL_VERSION, false );
	}
);
