import "./upgrade-paths-clone.js";
import "./refund-modal.js";
import "./order.js";
import "./retroactive.js";

jQuery( document ).ready( function ( $ ) {
	// find the #edd_sl_download_settings metabox and add data-edd-requires-licensing="true"
	$( '#edd_sl_download_settings' ).attr( 'data-edd-requires-licensing', 'true' );

	$( '#edd_sl_upgrade_paths_wrapper' ).on( 'change', 'select.edd-sl-upgrade-path-download', function () {
		var $this = $( this ), download_id = $this.val();

		if ( parseInt( download_id ) > 0 ) {
			var postData = {
				action: 'edd_check_for_download_price_variations',
				download_id: download_id
			};

			$.ajax( {
				type: "POST",
				data: postData,
				url: ajaxurl,
				success: function ( prices ) {
					var parent = $this.parents( '.edd-form-group' ),
						control = parent.next().find( '.edd-form-group__control' );

					if ( '' == prices ) {
						control.html( edd_sl.no_prices );
					} else {

						var prev = parent.next().find( '.edd-sl-upgrade-path-price-id' ),
							key = $this.parents( '.edd_repeatable_row' ).data( 'key' ),
							name = 'edd_sl_upgrade_paths[' + key + '][price_id]',
							id = 'edd_sl_upgrade_paths_' + key + '_price_id';

						prices = prices.replace( 'name="edd_price_option"', 'name="' + name + '" id="' + id + '"' );
						prev.remove();
						control.html( prices );
					}
				}
			} ).fail( function ( data ) {
				if ( window.console && window.console.log ) {
					console.log( data );
				}
			} );

		}
	} );

	$( '#edd_readme_cache button' ).on( 'click', function ( e ) {
		e.preventDefault();
		var postData = {
			action: 'edd_sl_clear_readme',
			download_id: edd_sl.download,
			nonce: edd_sl.readme_nonce,
		};

		$.ajax( {
			type: "POST",
			data: postData,
			url: ajaxurl,
			success: function ( response ) {
				var css_class = 'error inline';
				if ( response.success ) {
					css_class = 'updated inline';
				}

				$( '#edd_readme_cache' ).empty()
					.append( $( '<div />', {
						class: css_class,
					} ).append( $( '<p />', {
						text: response.data.message,
					} )
					) );
			}
		} );
	} );
	// End Download Edit Screen.

	// License Details Screen.
	$( '#edd_sl_send_renewal_notice' ).on( 'click', function ( e ) {
		e.preventDefault();

		if ( $( this ).text() === edd_sl.send_notice ) {
			$( '.edd-sl-license-card-notices' ).fadeIn( 'fast' ).css( 'display', 'table-row' );
			$( this ).text( edd_sl.cancel_notice );
		} else {
			$( '.edd-sl-license-card-notices' ).fadeOut( 'fast', function () {
				$( '.edd-sl-license-card-notices' ).css( 'display', 'none' );
			} );
			$( this ).text( edd_sl.send_notice );
		}
	} );

	$( '.edd-sl-adjust-limit' ).click( function ( e ) {
		e.preventDefault();
		var button = $( this ),
			direction = button.data( 'action' ),
			data = {
				action: 'edd_sl_' + direction + '_limit',
				license: button.data( 'id' ),
				download: button.data( 'download' )
			};
		button.toggleClass( 'button-disabled' );
		$.post( ajaxurl, data, function ( response, status ) {
			button.toggleClass( 'button-disabled' );
			$( '#edd-sl-' + data.license + '-limit' ).text( response );
			$( 'span[data-parent="' + data.license + '"]' ).text( response );
		} );
	} );


	$( 'input[name="edd_sl_is_lifetime"]' ).change( function () {
		var unlimited = $( this ).val();
		if ( unlimited == 1 ) {
			$( '#edd_license_length_wrapper' ).hide();
		} else {
			$( '#edd_license_length_wrapper' ).show();
		}
	} );

	$( '#edit_expiration_is_lifetime' ).change( function () {
		var checked = $( this ).is( ':checked' );

		if ( checked ) {
			$( '#edit_expiration_date' ).attr( 'disabled', 'disabled' );
		} else {
			$( '#edit_expiration_date' ).removeAttr( 'disabled' );
		}
	} );

	$( '.edd_sl_upgrade_link' ).on( 'click', function () {
		$( this ).select();
	} );

	$( '#edd-sl-license-delete-confirm' ).change( function () {
		var submit_button = $( '#edd-sl-delete-license' );

		if ( $( this ).prop( 'checked' ) ) {
			submit_button.attr( 'disabled', false );
		} else {
			submit_button.attr( 'disabled', true );
		}
	} );

	$( '.edd-sl-edit-license-exp-date' ).on( 'click', function ( e ) {
		e.preventDefault();

		var link = $( this );
		var exp_input = $( 'input.edd-sl-license-exp-date' );

		edd_sl_edit_license_exp_date( link, exp_input );

		$( '.edd-sl-license-exp-date' ).toggle();
	} );

	$( '.edd-sl-license-exp-date, #license_price_id' ).on( 'change', function () {
		$( '#edd_sl_update_license' ).fadeIn( 'fast' ).css( 'display', 'inline-block' );
	} );

	function edd_sl_edit_license_exp_date ( link, input ) {
		if ( link.text() === edd_sl.action_edit ) {
			link.data( 'current-value', input.val() );
			link.text( edd_sl.action_cancel );
		} else {
			input.val( link.data( 'current-value' ) );
			$( '#edd_sl_update_license' ).fadeOut( 'fast', function () {
				$( this ).css( 'display', 'none' );
			} );
			link.text( edd_sl.action_edit );
		}
	}

	$( '.edd-sl-license-card-notices input[type="submit"]' ).on( 'click', function ( e ) {
		e.preventDefault();

		var submitButton = $( this );
		submitButton.attr( 'disabled', true );
		submitButton.next( '.spinner' ).css( 'visibility', 'visible' );

		// Remove any error messages.
		var wrapper = $( this ).parents( 'td' );
		wrapper.find( '.notice.error' ).remove();

		var postData = {
			action: 'edd_sl_send_renewal_notice',
			license_id: $( this ).data( 'license-id' ),
			notice_id: $( '#edd_sl_renewal_notice' ).val()
		};

		$.ajax( {
			type: "POST",
			data: postData,
			dataType: 'json',
			url: ajaxurl,
			success: function ( response ) {
				if ( response.success ) {
					window.location = response.url;
				} else if ( response.message ) {
					submitButton.attr( 'disabled', false );
					submitButton.next( '.spinner' ).css( 'visibility', 'hidden' );
					wrapper.append( '<div class="notice error inline"><p>' + response.message + '</p></div>' );
				}
			}
		} ).fail( function ( data ) {
			if ( window.console && window.console.log ) {
				console.log( data );
			}
		} );
		return true;
	} );
	// End License Details Screen.

	// Tools Screen.
	$( '#edd-sl-regenerate-key' ).on( 'click', function ( e ) {

		var response = confirm( edd_sl.regenerate_notice );
		if ( response == false ) {
			return;
		}

		var license_key = $( '#license-key' );
		var target = $( this );
		target.css( 'color', '#999' ).css( 'pointer-events', 'none' );

		var postData = {
			action: 'edd_sl_regenerate_license',
			license_id: target.data( 'license-id' ),
			nonce: target.data( 'nonce' )
		};

		$.ajax( {
			type: "POST",
			data: postData,
			dataType: 'json',
			url: ajaxurl,
			success: function ( response ) {
				if ( response.success ) {
					license_key.fadeTo( 'fast', '.1', function () {
						license_key.text( response.key ).fadeTo( 'fast', '1', function () {
							target.css( 'color', '' ).css( 'pointer-events', '' );
						} );
					} );
				} else {
					target.css( 'color', '' ).css( 'pointer-events', '' );
				}
			}
		} ).fail( function ( data ) {
			if ( window.console && window.console.log ) {
				console.log( data );
			}
		} );

		return false;
	} );
	// End Tools Screen.

	// WP 3.5+ uploader
	var file_frame;
	window.formfield = '';

	$( document.body ).on( 'click', '.edd_upload_banner_button', function ( e ) {
		e.preventDefault();

		var button = $( this );

		window.formfield = $( this ).closest( '.edd_sl_banner_container' );

		// If the media frame already exists, reopen it.
		if ( file_frame ) {
			file_frame.open();
			return;
		}

		// Create the media frame.
		file_frame = wp.media.frames.file_frame = wp.media( {
			frame: 'post',
			state: 'insert',
			title: button.data( 'uploader-title' ),
			button: {
				text: button.data( 'uploader-button-text' )
			},
			multiple: false
		} );

		file_frame.on( 'menu:render:default', function ( view ) {
			// Store our views in an object.
			var views = {};

			// Unset default menu items
			view.unset( 'library-separator' );
			view.unset( 'gallery' );
			view.unset( 'featured-image' );
			view.unset( 'embed' );

			// Initialize the views in our view object.
			view.set( views );
		} );

		// When an image is selected, run a callback.
		file_frame.on( 'insert', function () {
			var selection = file_frame.state().get( 'selection' );
			selection.each( function ( attachment, index ) {
				attachment = attachment.toJSON();

				window.formfield.find( 'input' ).val( attachment.url );
			} );
		} );

		// Finally, open the modal
		file_frame.open();
	} );
} );
