/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/src/js/order.js":
/*!********************************!*\
  !*** ./assets/src/js/order.js ***!
  \********************************/
/***/ (() => {

// Add an event listner to the "Process Licenses" button on the order details screen.
document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('.order-licenses #edd-retroactive-processor');
  if (form) {
    const button = form.querySelector('button');
    button.addEventListener('click', eddRetroactiveProcessor);
  }
});

/**
 * This function is called when the "Process Licenses" button is clicked on the order details screen.
 * It's a replacement for the EDD_Export.process_step function in the EDD_Export object because that requires a form element.
 *
 * @param {event} e
 */
function eddRetroactiveProcessor(e) {
  e.preventDefault();

  // disable the button
  const button = e.target;
  button.setAttribute('disabled', 'disabled');
  button.classList.add('updating-message');
  const form = document.querySelector('#edd-retroactive-processor');
  const notice_wrap = form.querySelector('.notice-wrap');
  if (notice_wrap) {
    notice_wrap.remove();
  }
  const div = document.createElement('div');
  div.classList.add('notice-wrap');
  div.innerHTML = '<div class="edd-progress"><div></div></div>';
  form.appendChild(div);
  eddRetroactiveProcessorProcessStep(form, 1);
}
function eddRetroactiveProcessorProcessStep(form, step) {
  var formData = new FormData();
  formData.append('order_id', form.querySelector('input[name="order_id"]').value);
  formData.append('edd-export-class', form.querySelector('input[name="edd-export-class"]').value);
  formData.append('edd_ajax_export', form.querySelector('input[name="edd_ajax_export"]').value);

  // convert formData to a string
  var string = new URLSearchParams(formData).toString();
  var data = new FormData();
  data.append('action', 'edd_do_ajax_export');
  data.append('step', step);
  data.append('form', string);
  fetch(ajaxurl, {
    method: 'POST',
    body: data
  }).then(function (response) {
    return response.json();
  }).then(function (response) {
    if ('done' === response.step || response.error || response.success) {
      const export_form = document.querySelector('.edd-export-form').querySelector('.edd-progress').parentElement.parentElement;
      const notice_wrap = export_form.querySelector('.notice-wrap');
      export_form.querySelector('button').classList.remove('updating-message');
      export_form.querySelector('button').classList.add('updated-message');
      setTimeout(function () {
        export_form.querySelector('button').removeAttribute('disabled');
        export_form.querySelector('button').classList.remove('updated-message');
        if (notice_wrap) {
          notice_wrap.remove();
        }
        location.reload();
      }, 3000);
      if (response.error) {
        const error_message = response.message;
        notice_wrap.innerHTML = '<div class="updated error"><p>' + error_message + '</p></div>';
      } else if (response.success) {
        const success_message = response.message;
        notice_wrap.innerHTML = '<div id="edd-batch-success" class="updated notice"><p>' + success_message + '</p></div>';
        if (response.data) {
          Object.keys(response.data).forEach(function (key) {
            // do something
          });
        }
      }
    } else {
      // This really is likely a one step process but to work with the EDD export class we need to keep the process going.
      const progress = document.querySelector('.edd-progress div');
      progress.style.width = response.percentage + '%';
      eddRetroactiveProcessorProcessStep(form, parseInt(response.step));
    }
  });
}

/***/ }),

/***/ "./assets/src/js/refund-modal.js":
/*!***************************************!*\
  !*** ./assets/src/js/refund-modal.js ***!
  \***************************************/
/***/ (() => {

document.addEventListener('DOMContentLoaded', function (e) {
  document.body.addEventListener('input', function (event) {
    if (event.target.classList.contains('edd-order-item-refund-subtotal')) {
      const orderItemID = event.target.closest('tr').dataset.orderItem;
      if (orderItemID) {
        const license = document.querySelector('.edd-sl-license-order-item-' + orderItemID);
        if (license) {
          const total = parseFloat(event.target.value);
          const data_total = parseFloat(event.target.dataset.original);
          if (total < data_total) {
            license.classList.remove('edd-hidden');
          } else {
            license.classList.add('edd-hidden');
          }
        }
      }
    }
  });
});

/***/ }),

/***/ "./assets/src/js/retroactive.js":
/*!**************************************!*\
  !*** ./assets/src/js/retroactive.js ***!
  \**************************************/
/***/ (() => {

const retroactiveType = document.getElementById('sl-retro-type');
if (retroactiveType) {
  retroactiveType.addEventListener('change', function () {
    const type = this.value;
    const target = document.getElementById('sl-retro-single-wrapper');
    if (type === 'all') {
      target.style.display = 'none';
    } else {
      target.style.display = 'block';
    }
  });
}

/***/ }),

/***/ "./assets/src/js/upgrade-paths-clone.js":
/*!**********************************************!*\
  !*** ./assets/src/js/upgrade-paths-clone.js ***!
  \**********************************************/
/***/ (() => {

const upgradeWrapper = document.getElementById('edd_sl_upgrade_paths_wrapper');

// When an upgrade path is cloned, update the price field and labels.
const upgradePathAdded = function (mutationsList, observer) {
  for (var mutation of mutationsList) {
    if (mutation.type === 'childList') {
      for (var node of mutation.addedNodes) {
        if (node.classList.contains('edd-repeatable-upgrade-wrapper')) {
          var priceField = node.querySelector('.edd-sl-upgrade-price-control'),
            dataKey = node.getAttribute('data-key');
          priceField.innerHTML = edd_sl.no_prices;
          node.querySelectorAll('label').forEach(function (label) {
            var forAttr = label.getAttribute('for');
            if (undefined !== forAttr) {
              var string = forAttr.replace(/(\d+)/, parseInt(dataKey));
              label.setAttribute('for', string);
            }
          });
          var prorateField = node.querySelector('.sl-upgrade-prorate');
          prorateField.querySelector('input').checked = false;
        }
      }
    }
  }
};
if (upgradeWrapper) {
  const observer = new MutationObserver(upgradePathAdded);
  observer.observe(upgradeWrapper, {
    childList: true
  });
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!********************************!*\
  !*** ./assets/src/js/index.js ***!
  \********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _upgrade_paths_clone_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./upgrade-paths-clone.js */ "./assets/src/js/upgrade-paths-clone.js");
/* harmony import */ var _upgrade_paths_clone_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_upgrade_paths_clone_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _refund_modal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./refund-modal.js */ "./assets/src/js/refund-modal.js");
/* harmony import */ var _refund_modal_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_refund_modal_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _order_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./order.js */ "./assets/src/js/order.js");
/* harmony import */ var _order_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_order_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _retroactive_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./retroactive.js */ "./assets/src/js/retroactive.js");
/* harmony import */ var _retroactive_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_retroactive_js__WEBPACK_IMPORTED_MODULE_3__);




jQuery(document).ready(function ($) {
  // find the #edd_sl_download_settings metabox and add data-edd-requires-licensing="true"
  $('#edd_sl_download_settings').attr('data-edd-requires-licensing', 'true');
  $('#edd_sl_upgrade_paths_wrapper').on('change', 'select.edd-sl-upgrade-path-download', function () {
    var $this = $(this),
      download_id = $this.val();
    if (parseInt(download_id) > 0) {
      var postData = {
        action: 'edd_check_for_download_price_variations',
        download_id: download_id
      };
      $.ajax({
        type: "POST",
        data: postData,
        url: ajaxurl,
        success: function (prices) {
          var parent = $this.parents('.edd-form-group'),
            control = parent.next().find('.edd-form-group__control');
          if ('' == prices) {
            control.html(edd_sl.no_prices);
          } else {
            var prev = parent.next().find('.edd-sl-upgrade-path-price-id'),
              key = $this.parents('.edd_repeatable_row').data('key'),
              name = 'edd_sl_upgrade_paths[' + key + '][price_id]',
              id = 'edd_sl_upgrade_paths_' + key + '_price_id';
            prices = prices.replace('name="edd_price_option"', 'name="' + name + '" id="' + id + '"');
            prev.remove();
            control.html(prices);
          }
        }
      }).fail(function (data) {
        if (window.console && window.console.log) {
          console.log(data);
        }
      });
    }
  });
  $('#edd_readme_cache button').on('click', function (e) {
    e.preventDefault();
    var postData = {
      action: 'edd_sl_clear_readme',
      download_id: edd_sl.download,
      nonce: edd_sl.readme_nonce
    };
    $.ajax({
      type: "POST",
      data: postData,
      url: ajaxurl,
      success: function (response) {
        var css_class = 'error inline';
        if (response.success) {
          css_class = 'updated inline';
        }
        $('#edd_readme_cache').empty().append($('<div />', {
          class: css_class
        }).append($('<p />', {
          text: response.data.message
        })));
      }
    });
  });
  // End Download Edit Screen.

  // License Details Screen.
  $('#edd_sl_send_renewal_notice').on('click', function (e) {
    e.preventDefault();
    if ($(this).text() === edd_sl.send_notice) {
      $('.edd-sl-license-card-notices').fadeIn('fast').css('display', 'table-row');
      $(this).text(edd_sl.cancel_notice);
    } else {
      $('.edd-sl-license-card-notices').fadeOut('fast', function () {
        $('.edd-sl-license-card-notices').css('display', 'none');
      });
      $(this).text(edd_sl.send_notice);
    }
  });
  $('.edd-sl-adjust-limit').click(function (e) {
    e.preventDefault();
    var button = $(this),
      direction = button.data('action'),
      data = {
        action: 'edd_sl_' + direction + '_limit',
        license: button.data('id'),
        download: button.data('download')
      };
    button.toggleClass('button-disabled');
    $.post(ajaxurl, data, function (response, status) {
      button.toggleClass('button-disabled');
      $('#edd-sl-' + data.license + '-limit').text(response);
      $('span[data-parent="' + data.license + '"]').text(response);
    });
  });
  $('input[name="edd_sl_is_lifetime"]').change(function () {
    var unlimited = $(this).val();
    if (unlimited == 1) {
      $('#edd_license_length_wrapper').hide();
    } else {
      $('#edd_license_length_wrapper').show();
    }
  });
  $('#edit_expiration_is_lifetime').change(function () {
    var checked = $(this).is(':checked');
    if (checked) {
      $('#edit_expiration_date').attr('disabled', 'disabled');
    } else {
      $('#edit_expiration_date').removeAttr('disabled');
    }
  });
  $('.edd_sl_upgrade_link').on('click', function () {
    $(this).select();
  });
  $('#edd-sl-license-delete-confirm').change(function () {
    var submit_button = $('#edd-sl-delete-license');
    if ($(this).prop('checked')) {
      submit_button.attr('disabled', false);
    } else {
      submit_button.attr('disabled', true);
    }
  });
  $('.edd-sl-edit-license-exp-date').on('click', function (e) {
    e.preventDefault();
    var link = $(this);
    var exp_input = $('input.edd-sl-license-exp-date');
    edd_sl_edit_license_exp_date(link, exp_input);
    $('.edd-sl-license-exp-date').toggle();
  });
  $('.edd-sl-license-exp-date, #license_price_id').on('change', function () {
    $('#edd_sl_update_license').fadeIn('fast').css('display', 'inline-block');
  });
  function edd_sl_edit_license_exp_date(link, input) {
    if (link.text() === edd_sl.action_edit) {
      link.data('current-value', input.val());
      link.text(edd_sl.action_cancel);
    } else {
      input.val(link.data('current-value'));
      $('#edd_sl_update_license').fadeOut('fast', function () {
        $(this).css('display', 'none');
      });
      link.text(edd_sl.action_edit);
    }
  }
  $('.edd-sl-license-card-notices input[type="submit"]').on('click', function (e) {
    e.preventDefault();
    var submitButton = $(this);
    submitButton.attr('disabled', true);
    submitButton.next('.spinner').css('visibility', 'visible');

    // Remove any error messages.
    var wrapper = $(this).parents('td');
    wrapper.find('.notice.error').remove();
    var postData = {
      action: 'edd_sl_send_renewal_notice',
      license_id: $(this).data('license-id'),
      notice_id: $('#edd_sl_renewal_notice').val()
    };
    $.ajax({
      type: "POST",
      data: postData,
      dataType: 'json',
      url: ajaxurl,
      success: function (response) {
        if (response.success) {
          window.location = response.url;
        } else if (response.message) {
          submitButton.attr('disabled', false);
          submitButton.next('.spinner').css('visibility', 'hidden');
          wrapper.append('<div class="notice error inline"><p>' + response.message + '</p></div>');
        }
      }
    }).fail(function (data) {
      if (window.console && window.console.log) {
        console.log(data);
      }
    });
    return true;
  });
  // End License Details Screen.

  // Tools Screen.
  $('#edd-sl-regenerate-key').on('click', function (e) {
    var response = confirm(edd_sl.regenerate_notice);
    if (response == false) {
      return;
    }
    var license_key = $('#license-key');
    var target = $(this);
    target.css('color', '#999').css('pointer-events', 'none');
    var postData = {
      action: 'edd_sl_regenerate_license',
      license_id: target.data('license-id'),
      nonce: target.data('nonce')
    };
    $.ajax({
      type: "POST",
      data: postData,
      dataType: 'json',
      url: ajaxurl,
      success: function (response) {
        if (response.success) {
          license_key.fadeTo('fast', '.1', function () {
            license_key.text(response.key).fadeTo('fast', '1', function () {
              target.css('color', '').css('pointer-events', '');
            });
          });
        } else {
          target.css('color', '').css('pointer-events', '');
        }
      }
    }).fail(function (data) {
      if (window.console && window.console.log) {
        console.log(data);
      }
    });
    return false;
  });
  // End Tools Screen.

  // WP 3.5+ uploader
  var file_frame;
  window.formfield = '';
  $(document.body).on('click', '.edd_upload_banner_button', function (e) {
    e.preventDefault();
    var button = $(this);
    window.formfield = $(this).closest('.edd_sl_banner_container');

    // If the media frame already exists, reopen it.
    if (file_frame) {
      file_frame.open();
      return;
    }

    // Create the media frame.
    file_frame = wp.media.frames.file_frame = wp.media({
      frame: 'post',
      state: 'insert',
      title: button.data('uploader-title'),
      button: {
        text: button.data('uploader-button-text')
      },
      multiple: false
    });
    file_frame.on('menu:render:default', function (view) {
      // Store our views in an object.
      var views = {};

      // Unset default menu items
      view.unset('library-separator');
      view.unset('gallery');
      view.unset('featured-image');
      view.unset('embed');

      // Initialize the views in our view object.
      view.set(views);
    });

    // When an image is selected, run a callback.
    file_frame.on('insert', function () {
      var selection = file_frame.state().get('selection');
      selection.each(function (attachment, index) {
        attachment = attachment.toJSON();
        window.formfield.find('input').val(attachment.url);
      });
    });

    // Finally, open the modal
    file_frame.open();
  });
});
})();

/******/ })()
;
//# sourceMappingURL=edd-sl-admin.js.map