<?php
/**
 * Loader for remote requests.
 *
 * @package   EDD\SoftwareLicensing\RemoteRequests
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\RemoteRequests;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Class Handler
 *
 * @since 3.9.0
 * @package EDD\SoftwareLicensing\RemoteRequests
 */
class Loader implements SubscriberInterface {

	/**
	 * Get the subscribed events.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	public static function get_subscribed_events() {
		return array(
			'edd_activate_license'   => 'handle',
			'edd_deactivate_license' => 'handle',
			'edd_check_license'      => 'handle',
			'edd_get_version'        => 'handle',
		);
	}

	/**
	 * Handle the request.
	 *
	 * @since 3.9.0
	 * @param mixed $data The data.
	 * @return void
	 */
	public function handle( $data ) {
		$handlers = array(
			'edd_activate_license'   => 'Activate',
			'edd_deactivate_license' => 'Deactivate',
			'edd_check_license'      => 'Check',
			'edd_get_version'        => 'GetVersion',
		);

		$current_action = current_action();
		if ( ! isset( $handlers[ $current_action ] ) ) {
			return;
		}
		$handler = __NAMESPACE__ . '\\Requests\\' . $handlers[ $current_action ];
		if ( ! class_exists( $handler ) ) {
			return;
		}

		$handler = new $handler();
		$handler->handle( $data );
	}
}
