<?php
/**
 * The Action class.
 *
 * @package   EDD\SoftwareLicensing\Licenses\Actions
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Licenses\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Class Action
 *
 * @since 3.9.0
 * @package EDD\SoftwareLicensing\Licenses\Actions
 */
abstract class Action {

	/**
	 * Get the defaults.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	protected function get_defaults() {
		return array(
			'key'         => '',
			'item_name'   => '',
			'item_id'     => 0,
			'expiration'  => time(),
			'url'         => '',
			'environment' => 'production',
		);
	}
}
