<?php
/**
 * This file contains deprecated methods from the core Software Licensing class.
 *
 * @since 3.9.0
 *
 * @package EDD\SoftwareLicensing\Deprecated
 */

namespace EDD\SoftwareLicensing\Deprecated;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Core deprecations trait.
 *
 * @since 3.9.0
 */
trait Core {

	/**
	 * @param string $license_key
	 * @deprecated 3.4.7
	 *
	 * @return mixed|void
	 */
	public function get_download_by_license( $license_key ) {

		/*
		 * Deprecated in favor of get_download_id_by_license()
		 * See https://github.com/easydigitaldownloads/EDD-Software-Licensing/pull/479
		 */

		return $this->get_download_id_by_license( $license_key );
	}

	/**
	 * Update customer email on profile update
	 *
	 * @since 3.5
	 * @deprecated No longer used in 3.6 since license titles are not a property of licenses.
	 * @param bool  $updated whether or not the customer was updated
	 * @param int   $customer_id The ID of the customer
	 * @param array $data The updated data for the customer
	 * @return void
	 */
	public function update_license_email_on_customer_update( $updated = false, $customer_id = 0, $data = array() ) {
		_edd_deprecated_function( 'EDD_Software_Licensing::update_license_email_on_customer_update', '3.6', 'Email address are no longer stored on licenses directly' );
	}

	/**
	 * Revokes a license when the payment status changes (EDD 2.x).
	 *
	 * @deprecated 3.9.0
	 * @param int    $payment_id
	 * @param string $new_status
	 * @param string $old_status
	 */
	public function revoke_license( $payment_id, $new_status, $old_status ) {

		if ( function_exists( 'edd_get_order_items' ) ) {
			return;
		}

		$payment = new EDD_Payment( $payment_id );

		// Revoke license keys when the payment is refunded or revoked
		if ( ! in_array( $new_status, apply_filters( 'edd_sl_revoke_license_statuses', array( 'revoked', 'refunded' ) ) ) ) {
			return;
		}

		$licenses = $this->get_licenses_of_purchase( $payment->ID );

		if ( ! $licenses ) {
			return;
		}

		foreach ( $licenses as $license ) {

			$cart_item = $payment->cart_details[ $license->cart_index ];
			$upgrade   = ! empty( $cart_item['item_number']['options']['is_upgrade'] ) ? true : false;
			$renewal   = ! empty( $cart_item['item_number']['options']['is_renewal'] ) ? true : false;

			if ( $upgrade ) {
				$payment_index    = array_search( $payment_id, $license->payment_ids );
				$previous_payment = false;

				// Work our way backwards through the payment IDs until we find the first completed payment, ignoring others
				$key = $payment_index - 1;
				while ( $key >= 0 ) {
					$previous_payment = new EDD_Payment( $license->payment_ids[ $key ] );

					if ( 'publish' === $previous_payment->status || 'complete' === $previous_payment->status ) {
						break;
					}

					--$key;

				}

				if ( false === $previous_payment ) {
					continue;
				}

				// Set the download ID to the initial download ID (since it could change).
				$license->download_id = $previous_payment->cart_details[ $license->cart_index ]['id'];

				// Reset the price ID.
				if ( isset( $previous_payment->cart_details[ $license->cart_index ]['item_number']['options']['price_id'] ) ) {
					$license->price_id = $previous_payment->cart_details[ $license->cart_index ]['item_number']['options']['price_id'];
				} else {
					$license->price_id = null;
				}

				// Reset the activation limits.
				$license->reset_activation_limit();
			} else {

				// Don't revoke license keys when a renewal is refunded if the license is not expired
				if ( 'expired' !== $license->status && $renewal ) {
					continue;
				}

				do_action( 'edd_sl_pre_revoke_license', $license->ID, $payment_id );
				$license->disable();
				$license->update_meta( 'edd_sl_unsubscribed', current_time( 'timestamp' ) );
				do_action( 'edd_sl_post_revoke_license', $license->ID, $payment_id );
			}
		}
	}

	/**
	 * Activate a license.
	 *
	 * @param array $args The arguments.
	 * @deprecated 3.9.0
	 * @return array
	 */
	public function activate_license( $args ) {
		$activate = new \EDD\SoftwareLicensing\Licenses\Actions\Activate();

		return $activate->activate_license( $args );
	}

	/**
	 * Remote license activation.
	 *
	 * @param array $data The data.
	 * @deprecated 3.9.0
	 * @return void
	 */
	public function remote_license_activation( $data ) {
		$activate = new \EDD\SoftwareLicensing\RemoteRequests\Requests\Activate();

		$activate->handle( $data );
	}

	/**
	 * Deactivate a license.
	 *
	 * @param array $args The arguments.
	 * @deprecated 3.9.0
	 * @return bool
	 */
	public function deactivate_license( $args ) {
		$deactivate = new \EDD\SoftwareLicensing\Licenses\Actions\Deactivate();

		return $deactivate->deactivate_license( $args );
	}

	/**
	 * Remote license deactivation.
	 *
	 * @param array $data The data.
	 * @deprecated 3.9.0
	 * @return void
	 */
	public function remote_license_deactivation( $data ) {
		$deactivate = new \EDD\SoftwareLicensing\RemoteRequests\Requests\Deactivate();

		$deactivate->handle( $data );
	}

	/**
	 * Check a license.
	 *
	 * @param array $args The arguments.
	 * @return string
	 */
	public function check_license( $args ) {
		$check = new \EDD\SoftwareLicensing\Licenses\Actions\Check();

		return $check->check_license( $args );
	}

	/**
	 * Process both single and multiple licence checks.
	 *
	 * @param array $data The information of the item to check.
	 * @return array|void
	 */
	public function get_latest_version_remote( $data ) {
		$get_version = new \EDD\SoftwareLicensing\RemoteRequests\Requests\GetVersion();

		return $get_version->handle( $data );
	}
}
