<?php
/**
 * License Meta Table.
 *
 * @package   EDD\SoftwareLicensing\Database\Tables
 * @copyright Copyright (c) 2024, Easy Digital Downloads, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Tables;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Table;

/**
 * Setup the global "edd_license_activationmeta" database table
 *
 * @since 3.9.0
 */
final class LicenseActivationMeta extends Table {

	/**
	 * Table name
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var string
	 */
	protected $name = 'license_activationmeta';

	/**
	 * Database version
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var int
	 */
	protected $version = 202409240;

	/**
	 * Array of upgrade versions and methods
	 *
	 * @since 3.9.0
	 *
	 * @var array
	 */
	protected $upgrades = array();

	/**
	 * Setup the database schema
	 *
	 * @access protected
	 * @since 3.9.0
	 * @return void
	 */
	protected function set_schema() {
		$max_index_length = 191;
		$this->schema     = "
			meta_id bigint(20) unsigned NOT NULL auto_increment,
			edd_license_activation_id bigint(20) unsigned NOT NULL default '0',
			meta_key varchar(255) DEFAULT NULL,
			meta_value longtext DEFAULT NULL,
			PRIMARY KEY (meta_id),
			KEY edd_license_activation_id (edd_license_activation_id),
			KEY meta_key (meta_key({$max_index_length}))
		";
	}
}
