<?php
/**
 * License Activations database schema.
 *
 * @package   EDD\SoftwareLicensing\Database\Schemas
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Schemas;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Schema;

/**
 * Class LicenseActivations
 *
 * @since 3.9.0
 * @package EDD\Database\Schemas
 */
class LicenseActivations extends Schema {

	/**
	 * The database columns.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	public $columns = array(
		array(
			'name'     => 'id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'extra'    => 'auto_increment',
			'primary'  => true,
			'sortable' => true,
		),
		array(
			'name'       => 'site_name',
			'type'       => 'varchar',
			'length'     => 255,
			'sortable'   => true,
			'allow_null' => false,
			'searchable' => true,
		),
		array(
			'name'       => 'license_id',
			'type'       => 'bigint',
			'length'     => 20,
			'allow_null' => false,
		),
		array(
			'name'       => 'activated',
			'type'       => 'tinyint',
			'length'     => 1,
			'allow_null' => false,
		),
		array(
			'name'       => 'is_local',
			'type'       => 'tinyint',
			'length'     => 1,
			'allow_null' => false,
		),
		array(
			'name'       => 'date_created',
			'type'       => 'datetime',
			'default'    => null,
			'created'    => true,
			'date_query' => true,
			'sortable'   => true,
			'allow_null' => true,
		),
		array(
			'name'       => 'last_request',
			'type'       => 'datetime',
			'default'    => null,
			'modified'   => true,
			'date_query' => true,
			'sortable'   => true,
			'allow_null' => true,
		),
	);
}
