<?php
/**
 * Daily Events
 *
 * @package     EDD\SoftwareLicensing\Cron\Events
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.6 Originally in EDD_Cron
 * @since       3.9.0 Moved to EDD\Cron\Events
 */

namespace EDD\SoftwareLicensing\Cron\Events;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Cron\Events\Event;

/**
 * Daily Events.
 *
 * @since 3.9.0
 */
class Daily extends Event {
	/**
	 * Hook name.
	 *
	 * The hook that will fire when the Cron event is run.
	 *
	 * @var string
	 */
	protected $hook = 'edd_sl_daily_scheduled_events';

	/**
	 * First Run Time.
	 *
	 * The UTC timestamp to run the event for the first time.
	 *
	 * @var int
	 */
	protected $first_run = 0;

	/**
	 * Schedule.
	 *
	 * The registered WP Cron schedule to use.
	 *
	 * @var string
	 */
	protected $schedule = 'daily';
}
