<?php
/**
 * License Logs Component
 *
 * @package EDD\SoftwareLicensing\Components\LicenseLogs
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Components;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

class LicenseLogs {

	/**
	 * Register the license logs component.
	 *
	 * @since 3.9.0
	 * @return void
	 */
	public static function setup_components() {
		edd_register_component(
			'log_license',
			array(
				'schema' => '\\EDD\\SoftwareLicensing\\Database\\Schemas\\LogsLicenses',
				'table'  => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LogsLicenses',
				'query'  => '\\EDD\\SoftwareLicensing\\Database\\Queries\\LogLicense',
				'object' => '\\EDD\\SoftwareLicensing\\Licenses\\LogLicense',
				'meta'   => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LogsLicenseMeta',
			)
		);
	}
}
