<?php
/**
 * License Activation Data Component
 *
 * @package   EDD\SoftwareLicensing\Components
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Components;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * License Activation Data Component
 */
class LicenseActivationsData {

	/**
	 * Register the activation component.
	 *
	 * @since 3.9.0
	 * @return void
	 */
	public static function setup_components() {
		edd_register_component(
			'activation_data',
			array(
				'schema' => '\\EDD\\SoftwareLicensing\\Database\\Schemas\\LicenseActivationsData',
				'table'  => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LicenseActivationsData',
				'query'  => '\\EDD\\SoftwareLicensing\\Database\\Queries\\LicenseActivationsData',
				'object' => false,
				'meta'   => false,
			)
		);
	}
}
