<?php
/**
 * License  Component
 *
 * @package   EDD\SoftwareLicensing\Components
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Components;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

class LicenseActivations {

	/**
	 * Register the activation component.
	 *
	 * @since 3.9.0
	 * @return void
	 */
	public static function setup_components() {
		edd_register_component(
			'activation',
			array(
				'schema' => '\\EDD\\SoftwareLicensing\\Database\\Schemas\\LicenseActivations',
				'table'  => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LicenseActivations',
				'query'  => '\\EDD\\SoftwareLicensing\\Database\\Queries\\LicenseActivation',
				'object' => '\\EDD\\SoftwareLicensing\\Licenses\\LicenseActivation',
				'meta'   => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LicenseActivationMeta',
			)
		);
	}
}
