<?php
/**
 * Software Licensing Product Select Trait
 *
 * @package   EDD\SoftwareLicensing\Admin\Traits
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.1
 */

namespace EDD\SoftwareLicensing\Admin\Traits;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

trait ProductSelect {

	/**
	 * Filters the product dropdown to only show products with software licensing enabled.
	 *
	 * @since 3.9.1
	 * @param array $args The product arguments.
	 * @return array
	 */
	public function filter_product_dropdown( $args ) {
		$args['meta_query'] = array(
			array(
				'key'     => '_edd_sl_enabled',
				'value'   => '1',
				'compare' => '=',
			),
		);

		return $args;
	}
}
