<?php
/**
 * File Downloads
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * File Downloads
 */
class FileDownloads {

	/**
	 * The report registry.
	 *
	 * @var \EDD\Reports\Data\Report_Registry
	 */
	private $reports;

	/**
	 * Constructor.
	 *
	 * @param \EDD\Reports\Data\Report_Registry $reports The report registry.
	 */
	public function __construct( $reports ) {
		$this->reports = $reports;

		try {
			$this->register_report();
		} catch ( \Exception $e ) {
			// Do nothing.
		}
	}

	/**
	 * Register the report.
	 *
	 * @return void
	 */
	private function register_report() {
		try {
			$existing = $this->reports->get_report( 'file_downloads' );
			$this->reports->remove_report( 'file_downloads' );

			$tile_index = array_search( 'number_of_file_downloads', $existing['endpoints']['tiles'], true );
			if ( false !== $tile_index ) {
				$existing['endpoints']['tiles'][ $tile_index ] = 'sl_file_downloads_tile';
			}
			// Add our package downloads tile.
			$existing['endpoints']['tiles'][] = 'sl_package_downloads_tile';

			// Replace the core file downloads chart with our extended version.
			$chart_index = array_search( 'file_downloads_chart', $existing['endpoints']['charts'], true );
			if ( false !== $chart_index ) {
				$existing['endpoints']['charts'][ $chart_index ] = 'sl_file_downloads_chart';
			}
			// Add our package downloads chart.
			$existing['endpoints']['charts'][] = 'sl_package_downloads';

			$this->reports->add_report( 'file_downloads', $existing );

			// Register our custom endpoints.
			new Endpoints\Tiles\FileDownloads( $this->reports );
			new Endpoints\Tiles\PackageDownloads( $this->reports );
			new Endpoints\Charts\FileDownloads( $this->reports );
			new Endpoints\Charts\PackageDownloads( $this->reports );

		} catch ( \EDD_Exception $e ) {
			edd_debug_log_exception( $e );
		}
	}
}
