<?php
/**
 * File Downloads Tile
 *
 * @package     EDD\Reports\Endpoints\Tiles
 * @copyright   Copyright (c) 2025, Easy Digital Downloads, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Reports\Endpoints\Tiles\FileDownloads as Base;
use EDD\Reports;

/**
 * File Downloads Tile class.
 *
 * Displays the number of file downloads for the selected date range.
 *
 * @since 3.9.0
 */
class FileDownloads extends Base {

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_file_downloads_tile';
	}

	/**
	 * Gets the sales data.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_data(): string {
		global $wpdb;

		$download_data = $this->get_download_data();
		$product_id    = '';
		$price_id      = '';
		$date_sql      = $this->get_date_sql();

		if ( is_array( $download_data ) ) {
			$product_id = $wpdb->prepare( 'AND edd_lfd.product_id = %d', absint( $download_data['download_id'] ) );

			if ( isset( $download_data['price_id'] ) && is_numeric( $download_data['price_id'] ) ) {
				$price_id = $wpdb->prepare( 'AND edd_lfd.price_id = %d', absint( $download_data['price_id'] ) );
			}
		}

		return $wpdb->get_var(
			$wpdb->prepare(
				"SELECT COUNT(*)
				 FROM {$wpdb->edd_logs_file_downloads} edd_lfd
				 LEFT JOIN {$wpdb->edd_logs_file_downloadmeta} edd_lfd_meta
				 	ON edd_lfd.id = edd_lfd_meta.edd_logs_file_download_id
				 	AND edd_lfd_meta.meta_key = %s
				 WHERE edd_lfd_meta.meta_key IS NULL
				 AND ({$date_sql})
				 {$product_id} {$price_id}",
				'sl_package_download_license'
			)
		);
	}
}
