<?php
/**
 * Active Licenses (unique license IDs)
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.1
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Tiles;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Tiles\Tile;

/**
 * Active Licenses
 *
 * @since 3.9.1
 */
class ActiveLicenses extends Tile {
	use \EDD\SoftwareLicensing\Admin\Reports\Traits\Query;

	/**
	 * The date column for the query.
	 *
	 * @since 3.9.1
	 * @var string
	 */
	protected $date_column = 'last_request';

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.1
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_active_licenses';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.1
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'Active Licenses', 'edd_sl' );
	}

	/**
	 * Gets the data for the endpoint.
	 * Counts unique license IDs that have had API requests in the date range.
	 *
	 * @since 3.9.1
	 * @return mixed
	 */
	protected function get_data() {
		global $wpdb;
		$sql = "SELECT COUNT(DISTINCT license_id) FROM {$wpdb->prefix}edd_license_activations WHERE {$this->get_date_sql()} {$this->get_product_sql_query()}";

		return $wpdb->get_var( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
	}
}
