<?php
/**
 * All Activation Requests
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 * @deprecated 3.9.1
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Charts\Graph;
use EDD\Reports;

/**
 * All Activation Requests
 *
 * @since 3.9.0
 */
class AllRequests extends Graph {
	use \EDD\SoftwareLicensing\Admin\Reports\Traits\Query;

	/**
	 * The key for the dataset.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $key = 'requests';

	/**
	 * The date column for the query.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $date_column = 'last_request';

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_all_requests';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'All Requests', 'edd_sl' );
	}

	/**
	 * Gets the query results that will be used to build the chart.
	 *
	 * @since 3.9.0
	 * @return mixed
	 */
	protected function get_query_results(): array {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT COUNT(*) AS value, {$this->sql_clauses['select']}
				 FROM {$wpdb->edd_license_activations}
				 WHERE {$this->get_date_sql()} {$this->get_group_by()}"
			)
		);
	}

	/**
	 * Gets the chart arguments.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	protected function get_args(): array {
		$args                = parent::get_args();
		$args['borderColor'] = "rgb({$this->colors['blue']})";

		return $args;
	}
}
