<?php
/**
 * New Activations
 *
 * @package   EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Reports\Endpoints\Charts;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Reports\Endpoints\Charts\Graph;
use EDD\Reports;

/**
 * New Activations
 *
 * @since 3.9.0
 */
class Activations extends Graph {
	use \EDD\SoftwareLicensing\Admin\Reports\Traits\Query;

	/**
	 * The key for the dataset.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $key = 'activations';

	/**
	 * Gets the chart endpoint ID.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_id(): string {
		return 'sl_activation_line_graph';
	}

	/**
	 * Gets the chart label for display.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	protected function get_label(): string {
		return __( 'New Activations', 'edd_sl' );
	}

	/**
	 * Gets the query results that will be used to build the chart.
	 *
	 * @since 3.9.0
	 * @return mixed
	 */
	protected function get_query_results(): array {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT COUNT(*) AS value, {$this->sql_clauses['select']}
				 FROM {$wpdb->edd_license_activations}
				 WHERE {$this->get_date_sql()} {$this->get_group_by()}",
			)
		);
	}
}
