<?php
/**
 * Pages class
 *
 * @package EDD\SoftwareLicensing\Admin
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.1
 */

namespace EDD\SoftwareLicensing\Admin;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Pages class
 */
class Pages {

	/**
	 * Output the primary licenses page navigation
	 *
	 * @since 3.9.1
	 * @param string $active_tab The currently active tab. Default is empty string.
	 */
	public static function do_nav( $active_tab = '' ) {
		$tabs = array();
		foreach ( self::get() as $tab_id => $tab_name ) {
			$tabs[ $tab_id ] = array(
				'name' => $tab_name,
				'url'  => edd_get_admin_url(
					array(
						'page'      => 'edd-licenses',
						'page_type' => urlencode( $tab_id ),
					)
				),
			);
		}

		$navigation = new \EDD\Admin\Menu\SecondaryNavigation(
			$tabs,
			'edd-licenses',
			array(
				'active_tab'  => $active_tab,
				'show_search' => true,
			)
		);
		$navigation->render();
	}

	/**
	 * Retrieve the license pages.
	 * Used only by the primary tab navigation for licenses.
	 *
	 * @since 3.9.1
	 * @return array
	 */
	public static function get() {
		static $pages = null;

		// Filter.
		if ( null === $pages ) {
			$pages = (array) apply_filters(
				'edd_sl_get_license_pages',
				array(
					'licenses'    => esc_html__( 'Licenses', 'edd_sl' ),
					'activations' => esc_html__( 'Activations', 'edd_sl' ),
				)
			);
		}

		// Return.
		return $pages;
	}
}
