<?php
/**
 * WordPress Readme Parser section.
 *
 * @package EDD\SoftwareLicensing\Admin\Downloads\Editor
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Downloads\Editor;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore


use EDD\Admin\Downloads\Editor\Section;
use EDD\HTML\CheckboxToggle;
/**
 * WordPress Readme Parser section.
 *
 * @since 3.9.0
 */
class WPReadme extends Section {

	/**
	 * Section ID.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $id = 'wp-readme';

	/**
	 * Section priority.
	 *
	 * @since 3.9.0
	 * @var int
	 */
	protected $priority = 4;

	/**
	 * Section icon.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $icon = 'wordpress'; // phpcs:ignore

	/**
	 * Supports.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	protected $supports = array(
		'product-type' => array(
			'bundle'     => 'false',
			'all_access' => 'false',
			'service'    => 'false',
		),
	);

	/**
	 * Get the section label.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'Readme Info', 'edd_sl' );
	}

	/**
	 * Render the section.
	 *
	 * @since 3.9.0
	 */
	public function render() {
		$download = $this->item;
		if ( ! current_user_can( 'edit_product', $download->ID ) ) {
			return;
		}

		$readme_location = get_post_meta( $download->ID, '_edd_readme_location', true );
		$readme_sections = get_post_meta( $download->ID, '_edd_readme_sections', true );
		$readme_meta     = get_post_meta( $download->ID, '_edd_readme_meta', true );

		$readme_settings = array(
			'readme_meta'     => array(
				'title'       => __( 'Download Details', 'edd_sl' ),
				'description' => __( 'Use the following data from the remote readme.txt file . ', 'edd_sl' ),
				'settings'    => array(
					'tested_up_to'      => __( 'Tested Up To (WordPress Version)', 'edd_sl' ),
					'stable_tag'        => __( 'Stable Tag', 'edd_sl' ),
					'contributors'      => __( 'Contributors', 'edd_sl' ),
					'donate_link'       => __( 'Donate Link', 'edd_sl' ),
					'license'           => __( 'License', 'edd_sl' ),
					'remaining_content' => __( 'Other product details', 'edd_sl' ),
				),
			),
			'readme_sections' => array(
				'title'       => __( 'Download Tabs', 'edd_sl' ),
				'description' => __( 'Override the following sections with content from the remote readme.txt file. Each section appears as a tab in the Update Notice screen . ', 'edd_sl' ),
				'settings'    => array(
					'description'       => __( 'Description (default: Product content field)', 'edd_sl' ),
					'installation'      => __( 'Installation', 'edd_sl' ),
					'faq'               => __( 'FAQ', 'edd_sl' ),
					'changelog'         => __( 'Changelog (default: "Change Log" field)', 'edd_sl' ),
					'remaining_content' => __( 'Other tabs in the readme.txt', 'edd_sl' ),
				),
			),
		);

		?>
		<div class="edd-form-group" data-sl-supports-bundle="false">
			<?php edd_sl_render_readme_cache_status(); ?>
			<label for="edd_readme_location"><?php esc_html_e( 'Readme.txt Location:', 'edd_sl' ); ?></label>
			<input type="text" name="_edd_readme_location" class="widefat" id="edd_readme_location" value="<?php echo esc_attr( $readme_location ); ?>" placeholder="https://example.com/wp-content/plugins/example/readme.txt"/>
			<span class="edd-form-group__help description"><?php esc_html_e( 'What is the URL of the readme.txt file for the download?', 'edd_sl' ); ?></span>
		</div>

		<?php
		foreach ( $readme_settings as $settings_key => $settings_section ) {
			$current_settings = 'readme_meta' === $settings_key ? $readme_meta : $readme_sections;
			?>
			<fieldset class="edd-form-group" data-sl-supports-bundle="false">
				<legend class="edd-form-group__label" for="_edd_<?php echo esc_attr( $settings_key ); ?>"><?php echo esc_html( $settings_section['title'] ); ?></legend>
				<p class="edd-form-group__help description"><?php echo esc_html( $settings_section['description'] ); ?></p>
				<?php
				foreach ( $settings_section['settings'] as $key => $value ) {
					$toggle = new CheckboxToggle(
						array(
							'id'      => '_edd_' . $settings_key . '[' . $key . ']',
							'name'    => '_edd_' . $settings_key . '[' . $key . ']',
							'label'   => $value,
							'current' => array_key_exists( $key, (array) $current_settings ),
							'class'   => 'edd-form-group__control',
						)
					);
					$toggle->output();
				}
				?>
			</fieldset>
			<?php
		}

		$plugin_banner_high = get_post_meta( $download->ID, '_edd_readme_plugin_banner_high', true );
		$plugin_banner_low  = get_post_meta( $download->ID, '_edd_readme_plugin_banner_low', true );
		?>
		<div class="edd-form-group" data-sl-supports-bundle="false">
			<label for="edd_readme_plugin_banner_high"><?php esc_html_e( 'High Resolution Banner Image:', 'edd_sl' ); ?></label>
			<div class="edd-form-group__control">
				<div class="edd_sl_banner_container">
					<input type="text" name="_edd_readme_plugin_banner_high" class="widefat" id="edd_readme_plugin_banner_high" value="<?php echo esc_attr( $plugin_banner_high ); ?>" placeholder="https://www.example.com/banner-1544x500.jpg"/>
					<span class="edd_upload_banner">
						<a href="#" data-uploader-title="<?php esc_attr_e( 'Insert Image', 'edd_sl' ); ?>" data-uploader-button-text="<?php esc_attr_e( 'Insert', 'edd_sl' ); ?>" class="edd_upload_banner_button" onclick="return false;"><?php esc_html_e( 'Upload an Image', 'edd_sl' ); ?></a>
					</span>
				</div>
				<span class="edd-form-group__help description"><?php esc_html_e( 'URL of a banner image to use (1544x500 pixels)', 'edd_sl' ); ?></span>
			</div>
			<label for="edd_readme_plugin_banner_low"><?php esc_html_e( 'Low Resolution Banner Image:', 'edd_sl' ); ?></label>
			<div class="edd-form-group__control">
				<div class="edd_sl_banner_container">
					<input type="text" name="_edd_readme_plugin_banner_low" class="widefat" id="edd_readme_plugin_banner_low" value="<?php echo esc_attr( $plugin_banner_low ); ?>" placeholder="https://www.example.com/banner-772x250.jpg"/>
					<span class="edd_upload_banner">
						<a href="#" data-uploader-title="<?php esc_attr_e( 'Insert Image', 'edd_sl' ); ?>" data-uploader-button-text="<?php esc_attr_e( 'Insert', 'edd_sl' ); ?>" class="edd_upload_banner_button" onclick="return false;"><?php esc_html_e( 'Upload an Image', 'edd_sl' ); ?></a>
					</span>
				</div>
				<span class="edd-form-group__help description"><?php esc_html_e( 'URL of a banner image to use (772x250 pixels)', 'edd_sl' ); ?></span>
			</div>
		</div>
		<?php

		$plugin_homepage = get_post_meta( $download->ID, '_edd_readme_plugin_homepage', true );
		?>
		<div class="edd-form-group" data-sl-supports-bundle="false">
			<label for="_edd_readme_plugin_homepage"><?php esc_html_e( 'Override plugin homepage:', 'edd_sl' ); ?></label>
			<span class="howto"><?php esc_html_e( 'Leave blank to use the default plugin homepage (the URL of this Download page)', 'edd_sl' ); ?></span>
			<input type="text" name="_edd_readme_plugin_homepage" class="widefat" id="edd_readme_plugin_homepage" value="<?php echo esc_attr( $plugin_homepage ); ?>" placeholder="https://www.plugin-homepage.com"/>
		</div>

		<?php $plugin_added = get_post_meta( $download->ID, '_edd_readme_plugin_added', true ); ?>
		<div class="edd-form-group" data-sl-supports-bundle="false">
			<?php
			$toggle = new CheckboxToggle(
				array(
					'id'      => '_edd_readme_plugin_added',
					'name'    => '_edd_readme_plugin_added',
					'value'   => '1',
					'label'   => __( 'Use Download "Published on" date as Plugin Added date?', 'edd_sl' ),
					'current' => ! empty( $plugin_added ),
				)
			);
			$toggle->output();
			?>
		</div>

		<?php
		// Release some memory.
		unset( $plugin_banner_high, $plugin_banner_low, $plugin_homepage, $output, $readme_location, $readme_sections, $readme_settings );
	}
}
