<?php
/**
 * Upgrades section.
 *
 * @package EDD\SoftwareLicensing\Admin\Downloads\Editor
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Downloads\Editor;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Admin\Downloads\Editor\Section;

/**
 * Upgrades section.
 *
 * @since 3.9.0
 */
class Upgrades extends Section {

	/**
	 * Section ID.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $id = 'upgrades';

	/**
	 * Section priority.
	 *
	 * @since 3.9.0
	 * @var int
	 */
	protected $priority = 10;

	/**
	 * Section icon.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $icon = 'arrow-up-alt';

	/**
	 * Get the section label.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'Upgrades', 'edd_sl' );
	}

	/**
	 * Render the section.
	 *
	 * @since 3.9.0
	 */
	public function render() {
		$download = $this->item;
		if ( ! current_user_can( 'edit_product', $download->ID ) ) {
			return;
		}

		$paths = edd_sl_get_upgrade_paths( $download->ID );
		if ( empty( $paths ) ) {
			$paths = array(
				1 => array(),
			);
		}
		?>
		<p class="description"><?php esc_html_e( 'Configure the optional upgrade paths for customers. ', 'edd_sl' ); ?></p>
		<div id="edd_sl_upgrade_paths_wrapper" class="edd_meta_table_wrap">
			<div class="widefat edd_repeatable_table">
				<div class="edd-sl-upgrade-path-fields edd-repeatables-wrap">
					<?php
					foreach ( $paths as $key => $args ) :
						$index = ! empty( $args['index'] ) ? $args['index'] : $key;
						?>
						<div class="edd-repeatable-upgrade-wrapper edd_repeatable_row" data-key="<?php echo esc_attr( $key ); ?>">
							<?php do_action( 'edd_sl_render_upgrade_row', $key, $args, $index ); ?>
						</div>
						<?php
					endforeach;
					?>
				</div> <!-- edd-sl-upgrade-path-fields edd-repeatables-wrap -->
				<div class="edd-add-repeatable-row">
					<button class="button-secondary edd_add_repeatable"><?php esc_html_e( 'Add New Upgrade Path', 'edd_sl' ); ?></button>
				</div>
			</div>
		</div>
		<?php
	}
}
