<?php
/**
 * Requirements section.
 *
 * @package EDD\SoftwareLicensing\Admin\Downloads\Editor
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Admin\Downloads\Editor;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Admin\Downloads\Editor\Section;
use EDD\HTML\Text;

/**
 * Requirements section.
 *
 * @since 3.9.0
 */
class Requirements extends Section {

	/**
	 * Section ID.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $id = 'requirements';

	/**
	 * Section priority.
	 *
	 * @since 3.9.0
	 * @var int
	 */
	protected $priority = 3;

	/**
	 * Section icon.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $icon = 'filter';

	/**
	 * Get the section label.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'Requirements', 'edd_sl' );
	}

	/**
	 * Supports.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	protected $supports = array(
		'product-type' => array(
			'bundle'     => 'false',
			'all_access' => 'false',
			'service'    => 'false',
		),
	);

	/**
	 * Render the section.
	 *
	 * @since 3.9.0
	 */
	public function render() {
		$download = $this->item;
		if ( ! current_user_can( 'edit_product', $download->ID ) ) {
			return;
		}

		?>
		<div class="edd-form-group">
			<?php esc_html_e( 'Setting minimum version requirements for dependencies of your licensed product will prevent users from getting updates for your product if the site/platform does not meet the requirements.', 'edd_sl' ); ?>
			<?php
			printf(
				/* translators: %1$s: Link to minimum requirements documentation, %2$s: Link closing tag */
				__( 'Read more about %1$sMinimum Requirements%2$s', 'edd_sl' ),
				sprintf(
					'<a href="%s" target="_blank">',
					esc_url(
						edd_link_helper(
							'https://easydigitaldownloads.com/docs/software-licensing-minimum-requirements/',
							array(
								'utm_medium'  => 'edit-download',
								'utm_content' => 'minimum-requirements',
							)
						)
					)
				),
				'</a>'
			);
			?>
		</div>
		<?php
		$requirements = edd_sl_get_platforms();
		$metadata     = get_post_meta( $download->ID, '_edd_sl_required_versions', true );
		foreach ( $requirements as $key => $label ) {
			$value = ! empty( $metadata[ $key ] ) ? $metadata[ $key ] : '';
			?>
			<div class="edd-form-group">
				<div class="edd-form-group__control">
					<label class="edd-form-group__label" for="edd_sl_required_versions_<?php echo esc_attr( $key ); ?>">
						<?php
						printf(
							/* translators: %s: Platform label. For example, WordPress Version Required, PHP Version Required, etc. */
							esc_html__( 'Minimum %s Version Required:', 'edd_sl' ),
							$label
						);
						?>
					</label>
					<?php
					$required_version_input = new Text(
						array(
							'name'  => 'edd_sl_required_versions[' . esc_attr( $key ) . ']',
							'id'    => 'edd_sl_required_versions_' . esc_attr( $key ),
							'value' => esc_html( $value ),
							'class' => 'edd-form-group__input',
						)
					);

					$required_version_input->output();
					?>
				</div>
			</div>
			<?php
		}
	}
}
