<?php

/**
 * Prevents non-published downloads from sending renewal notices
 *
 * @since 3.4
 * @return bool
 */
function edd_sl_exclude_non_published_download_renewals( $send = true, $license_id = 0, $notice_id = 0 ) {

	$license = edd_software_licensing()->get_license( $license_id );

	// If we failed to find a license, don't send anything.
	if ( false === $license ) {
		return false;
	}

	$status = get_post_field( 'post_status', $license->download_id );

	if ( $status && 'publish' !== $status ) {
		$send = false;
	}

	return $send;
}
add_filter( 'edd_sl_send_scheduled_reminder_for_license', 'edd_sl_exclude_non_published_download_renewals', 10, 3 );

/**
 * Retrieve renewal notices
 *
 * @since 3.0
 * @return array Renewal notice periods
 */
function edd_sl_get_renewal_notice_periods() {
	$periods = array(
		'+1day'    => __( 'One day before expiration', 'edd_sl' ),
		'+2days'   => __( 'Two days before expiration', 'edd_sl' ),
		'+3days'   => __( 'Three days before expiration', 'edd_sl' ),
		'+1week'   => __( 'One week before expiration', 'edd_sl' ),
		'+2weeks'  => __( 'Two weeks before expiration', 'edd_sl' ),
		'+1month'  => __( 'One month before expiration', 'edd_sl' ),
		'+2months' => __( 'Two months before expiration', 'edd_sl' ),
		'+3months' => __( 'Three months before expiration', 'edd_sl' ),
		'expired'  => __( 'At the time of expiration', 'edd_sl' ),
		'-1day'    => __( 'One day after expiration', 'edd_sl' ),
		'-2days'   => __( 'Two days after expiration', 'edd_sl' ),
		'-3days'   => __( 'Three days after expiration', 'edd_sl' ),
		'-1week'   => __( 'One week after expiration', 'edd_sl' ),
		'-2weeks'  => __( 'Two weeks after expiration', 'edd_sl' ),
		'-1month'  => __( 'One month after expiration', 'edd_sl' ),
		'-2months' => __( 'Two months after expiration', 'edd_sl' ),
		'-3months' => __( 'Three months after expiration', 'edd_sl' ),
	);

	return apply_filters( 'edd_sl_get_renewal_notice_periods', $periods );
}

/**
 * Retrieve the renewal label for a notice
 *
 * @since 3.0
 * @return String
 */
function edd_sl_get_renewal_notice_period_label( $notice_id = 0 ) {

	$notice  = edd_sl_get_renewal_notice( $notice_id );
	$periods = edd_sl_get_renewal_notice_periods();
	$label   = $periods[ $notice['send_period'] ];

	return apply_filters( 'edd_sl_get_renewal_notice_period_label', $label, $notice_id );
}

/**
 * Retrieve a renewal notice
 *
 * @since 3.0
 * @return array Renewal notice details
 */
function edd_sl_get_renewal_notice( $notice_id = 0 ) {

	$notices  = edd_sl_get_renewal_notices();
	$defaults = array(
		'subject'     => __( 'Your License Key is About to Expire', 'edd_sl' ),
		'send_period' => '+1month',
		'message'     => 'Hello {name},

Your license key for {product_name} is about to expire.

If you wish to renew your license, simply click the link below and follow the instructions.

Your license expires on: {expiration}.

Your expiring license key is: {license_key}.

Renew now: {renewal_link}.',
		'enabled'     => true,
	);

	$notice = isset( $notices[ $notice_id ] ) ? $notices[ $notice_id ] : $defaults;
	$notice = wp_parse_args( $notice, $defaults );

	return apply_filters( 'edd_sl_renewal_notice', $notice, $notice_id );
}

/**
 * Retrieve renewal notice periods
 *
 * @since 3.0
 * @deprecated 3.9.0
 * @return array Renewal notices defined in settings
 */
function edd_sl_get_renewal_notices() {
	return apply_filters( 'edd_sl_get_renewal_notices', array() );
}
