<?php

$base         = admin_url( 'edit.php?post_type=download&page=edd-licenses&view=overview&license_id=' . $license->ID );
$base         = remove_query_arg( 'edd-message' );
$base         = wp_nonce_url( $base, 'edd_sl_license_nonce' );
$has_children = $license->get_child_licenses();
$unsubscribed = $license->get_meta( 'edd_sl_unsubscribed', true );

$initial_payment = edd_get_order( $license->payment_id );

do_action( 'edd_sl_license_card_top', $license->key );
?>
<div class="info-wrapper item-section">
	<form id="edit-item-info" method="post" action="<?php echo admin_url( 'edit.php?post_type=download&page=edd-licenses&view=overview&license_id=' . $license->ID ); ?>">
		<div class="item-info">
			<table class="widefat striped">
				<tbody>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'License Key:', 'edd_sl' ); ?></label>
						</td>
						<td style="word-wrap: break-word">
							<span id="license-key"><?php echo esc_html( $license->key ); ?></span>
							<?php if ( current_user_can( 'manage_licenses' ) ) : ?>
							<span>
								<a id="edd-sl-regenerate-key"
									href="#"
									title="Regenerate License Key"
									data-nonce="<?php echo esc_attr( wp_create_nonce( 'edd-sl-regenerate-license' ) ); ?>"
									data-license-id="<?php echo absint( $license->id ); ?>"
								>
									<span class="dashicons dashicons-update"></span>
								</a>
								<?php
								$tooltip = new EDD\HTML\Tooltip(
									array(
										'title'   => __( 'Regenerate License Key', 'edd_sl' ),
										'content' => __( 'In the event that a user needs to have their license key changed, using this button will assign a new key to this license', 'edd_sl' ),
									)
								);
								$tooltip->output();
								?>
							</span>
							<?php endif; ?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Purchase Date:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							if ( false === $initial_payment ) {
								?>
								&mdash;
								<?php
								$tooltip = new EDD\HTML\Tooltip(
									array(
										'title'   => __( 'Missing Purchase Date', 'edd_sl' ),
										'content' => __( 'The originating order for this license is missing or invalid.', 'edd_sl' ),
									)
								);
								$tooltip->output();
							} else {
								$payment_date = edd_date_i18n( strtotime( $initial_payment->date_created ), get_option( 'date_format' ) );
								if ( $license->payment_id && ! $license->parent ) {
									$payment_url = admin_url( 'edit.php?post_type=download&page=edd-payment-history&view=view-order-details&id=' . $license->payment_id );
									echo '<a href="' . esc_url( $payment_url ) . '">' . esc_html( $payment_date ) . '</a>';
								} else {
									echo esc_html( $payment_date );
								}
							}
							?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Expiration Date:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							$exp_date             = ucfirst( $license->expiration );
							$classes              = 'hidden edd-sl-license-exp-date edd_datepicker';
							$parent_license       = $license->parent > 0 ? edd_software_licensing()->get_license( $license->parent ) : false;
							$datepicker_timestamp = '';

							if ( ! $license->is_lifetime ) {
								if ( $license->parent == 0 ) {
									$datepicker_timestamp = $exp_date;
									$exp_date             = edd_date_i18n( $exp_date, get_option( 'date_format' ) );
								} else {
									if ( is_int( $parent_license->expiration ) ) {
										$datepicker_timestamp = $parent_license->expiration;
									}

									$exp_date = edd_date_i18n( $parent_license->expiration, get_option( 'date_format' ) );
								}
							}
							if ( ! empty( $datepicker_timestamp ) ) {
								$datepicker_timestamp = date( 'm/d/Y', $datepicker_timestamp );
							}
							?>
							<span class="edd-sl-license-exp-date"><?php echo esc_html( $exp_date ); ?></span>
							<input type="text" name="exp_date" class="<?php echo esc_attr( $classes ); ?>" value="<?php echo esc_attr( $datepicker_timestamp ); ?>" />

							<?php if ( $license->parent == 0 ) : ?>
							<span>&nbsp;&ndash;&nbsp;</span>
							<a class="edd-sl-edit-license-exp-date"><?php esc_html_e( 'Edit', 'edd_sl' ); ?></a>
							<?php endif; ?>

							<?php
							if ( $license->parent > 0 ) {
								printf( __( '(Set by <a href="%s">parent license</a>)', 'edd_sl' ), add_query_arg( 'license_id', $parent_license->ID ) );
							}
							?>

							<?php
							if ( empty( $license->parent ) && ! $license->is_lifetime ) {
								printf( 'or&nbsp;<a href="%s&action=%s">' . esc_html__( 'Mark as Lifetime', 'edd_sl' ) . '</a>', $base, 'set-lifetime' );
							}
							?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'License Term', 'edd_sl' ); ?>:</label>
						</td>
						<td>
							<span class="license-term"><?php echo $license->license_term(); ?></span>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Product:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							$download_name = $license->get_download()->get_name();
							if ( strrpos( $download_name, ' &#8211; ' ) ) {
								$download_name = trim( substr( $download_name, 0, strrpos( $download_name, ' &#8211; ' ) ) );
							}
							$download_name = '<a href="' . admin_url( 'post.php?post=' . $license->download_id . '&action=edit' ) . '">' . $download_name . '</a>';
							$price_id      = false;

							if ( $license->get_download()->has_variable_prices() ) {
								$price_id = $license->price_id;
								$prices   = $license->get_download()->get_prices();

								$options = array();
								if ( empty( $license->parent ) ) {
									foreach ( $prices as $id => $price ) {
										$options[ $id ] = $price['name'];
									}
								} elseif ( is_numeric( $price_id ) && ! empty( $prices[ $price_id ]['name'] ) ) {
									$child_price_id_label = $prices[ $price_id ]['name'];
								}
							}

							echo $download_name;
							if ( ! empty( $options ) ) {
								echo ' - ';
								echo EDD()->html->select(
									array(
										'name'             => 'price_id',
										'id'               => 'license-price-id',
										'show_option_all'  => false,
										'show_option_none' => false,
										'options'          => $options,
										'selected'         => $price_id,
									)
								);
							} elseif ( ! empty( $child_price_id_label ) ) {
								echo ' (' . esc_html( $child_price_id_label ) . ')';
							}
							?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Activation Limit:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							$limit = $license->license_limit();
							$data  = '';

							if ( $license->parent ) {
								$data .= 'data-parent="' . $license->parent . '"';
							}
							$active_count = $license->activation_count;
							$limit_text   = '<span id="edd-sl-' . $license->ID . '-limit" ' . $data . '>' . $limit . '</span>';

							echo '<span class="edd-sl-limit-wrap">' . $active_count . ' / ' . $limit_text . '</span>';

							if ( ! $license->parent ) {
								echo '<span style="margin-left: 15px">';
								echo '<a href="#" class="edd-sl-adjust-limit button-secondary" data-action="increase" data-id="' . absint( $license->ID ) . '" data-download="' . absint( $license->download_id ) . '">+</a>';
								echo '&nbsp;<a href="#" class="edd-sl-adjust-limit button-secondary" data-action="decrease" data-id="' . absint( $license->ID ) . '" data-download="' . absint( $license->download_id ) . '">-</a>';
								echo '</span>';

								$default_count = $license->get_default_activation_count();

								$message  = sprintf(
									__( 'The default activation limit for this license is %1$s, which is controlled by the %2$s product.', 'edd_sl' ),
									! empty( $default_count ) ? $default_count : __( 'Unlimited', 'edd_sl' ),
									$license->get_download()->get_name()
								);
								$message .= '<br /><br />';
								$message .= __( 'To modify this license, use the +/- to increase or decrease the number of activations, respectively. To allow unlimited activations for this license, reduce the activation limit to 0.', 'edd_sl' );

								$tooltip = new EDD\HTML\Tooltip(
									array(
										'title'   => __( 'Change License Limit', 'edd_sl' ),
										'content' => $message,
									)
								);
								$tooltip->output();
							}
							?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Status:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							echo edd_sl_get_license_status_badge( $license->status );
							$tooltip_content  = '<br />';
							$tooltip_content .= sprintf(
								'<strong>%s</strong>: %s',
								__( 'Active' ),
								__( 'Indicates that a user has activated a site with this license.' )
							);
							$tooltip_content .= '<br /><br />';
							$tooltip_content .= sprintf(
								'<strong>%s</strong>: %s',
								__( 'Inactive' ),
								__( 'Indicates that this license is not currently activated on any sites.' )
							);
							$tooltip_content .= '<br /><br />';
							$tooltip_content .= sprintf(
								'<strong>%s</strong>: %s',
								__( 'Expired' ),
								__( 'Indicates that this license has expired and can not be used unless renewed.' )
							);
							$tooltip_content .= '<br /><br />';
							$tooltip_content .= sprintf(
								'<strong>%s</strong>: %s',
								__( 'Disabled' ),
								__( 'Indicates that this license has been administratively disabled.' )
							);
							$tooltip          = new EDD\HTML\Tooltip(
								array(
									'title'   => __( 'What does this mean?', 'edd_sl' ),
									'content' => $tooltip_content,
								)
							);
							$tooltip->output();
							?>
						</td>
					</tr>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Customer:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							$customer_id = $license->customer_id;
							$customer    = new EDD_Customer( $customer_id );
							$name        = empty( $customer->name ) ? $customer->email : $customer->name;
							echo '<a href="' . esc_url( admin_url( 'edit.php?post_type=download&page=edd-customers&view=overview&id=' ) . $customer->id ) . '">' . $name . '</a>';
							?>
						</td>
					</tr>
					<?php if ( ! $license->is_lifetime ) : ?>
						<tr>
							<td class="row-title">
								<label for="tablecell"><?php esc_html_e( 'Email Notifications:', 'edd_sl' ); ?></label>
							</td>
							<td>
								<?php
								if ( $unsubscribed ) {
									printf( __( 'Unsubscribed on %s', 'edd_sl' ), date_i18n( 'Y-n-d H:i:s', $unsubscribed ) );
								} else {
									esc_html_e( 'Subscribed', 'edd_sl' );
								}
								$tooltip = new EDD\HTML\Tooltip(
									array(
										'title'   => __( 'Email Notifications', 'edd_sl' ),
										'content' => __( 'This indicates whether this customer will receive the license renewal email notifications configured in the Software Licensing settings tab.', 'edd_sl' ),
									)
								);
								$tooltip->output();
								$button_text   = $unsubscribed ? __( 'Subscribe', 'edd_sl' ) : __( 'Unsubscribe', 'edd_sl' );
								$subscribe_url = wp_nonce_url(
									add_query_arg(
										array(
											'edd_action' => 'sl_toggle_license_subscription',
											'subscription_status' => $unsubscribed ? 'subscribe' : 'unsubscribe',
											'license_id' => urlencode( $license->id ),
										),
										$base
									),
									'edd_sl_update_email_notifications'
								);
								?>
								<a href="<?php echo esc_url( $subscribe_url ); ?>"><?php echo esc_html( $button_text ); ?></a>
							</td>
						</tr>
					<?php endif; ?>
					<tr>
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Actions:', 'edd_sl' ); ?></label>
						</td>
						<td class="edd-sl-license-card-actions">
							<?php
							$actions = array();
							$status  = $license->status;

							if ( ! $license->parent ) {
								if ( ! $license->is_lifetime ) {

									if ( ! $unsubscribed && edd_sl_renewals_allowed() ) {
										$actions['renewal_notice'] = '<a id="edd_sl_send_renewal_notice" title="' . esc_attr__( 'Send a renewal notice for this license key', 'edd_sl' ) . '">' . esc_html__( 'Send Renewal Notice', 'edd_sl' ) . '</a>';
									}

									if ( 'disabled' !== $license->status ) {
										if ( 'expired' !== $status ) {
											$actions['renew'] = sprintf( '<a href="%s&action=%s" title="' . __( 'Extend this license key\'s expiration date', 'edd_sl' ) . '">' . __( 'Extend', 'edd_sl' ) . '</a>', $base, 'renew', $license->ID );
										} else {
											$actions['renew'] = sprintf( '<a href="%s&action=%s">' . __( 'Renew', 'edd_sl' ) . '</a>', $base, 'renew' );
										}
									}
								}

								if ( 'disabled' === $license->status ) {
									$actions['enable'] = sprintf( '<a href="%s&action=%s">' . __( 'Enable', 'edd_sl' ) . '</a>', $base, 'enable' );
								} else {
									$actions['disable'] = sprintf( '<a href="%s&action=%s">' . __( 'Disable', 'edd_sl' ) . '</a>', $base, 'disable' );
								}
							}

							$actions = apply_filters( 'edd_sl_license_details_actions', $actions, $license->ID );
							if ( ! empty( $actions ) ) {
								$count = count( $actions );
								$i     = 1;

								foreach ( $actions as $action ) {
									echo $action;

									if ( $i < $count ) {
										echo '&nbsp;|&nbsp;';
										++$i;
									}
								}
							} else {
								esc_html_e( 'No actions available for this license', 'edd_sl' );
							}
							?>
						</td>
					</tr>
					<tr class="edd-sl-license-card-notices">
						<td class="row-title">
							<label for="tablecell"><?php esc_html_e( 'Select Notice:', 'edd_sl' ); ?></label>
						</td>
						<td>
							<?php
							$notices = array();
							foreach ( edd_software_licensing()->notices->get_registered_notices() as $notice ) {
								if ( $notice instanceof \EDD\Emails\Email ) {
									$id      = $notice->email_id;
									$subject = $notice->subject;
								} else {
									$id      = $notice['email_id'];
									$subject = $notice['subject'];
								}
								$notices[ $id ] = $subject;
							}
							?>
							<select name="edd_sl_renewal_notice" id="edd_sl_renewal_notice">
								<?php
								foreach ( $notices as $notice_id => $notice_data ) {
									echo '<option value="' . esc_attr( $notice_id ) . '">' . esc_html( $subject ) . '</option>';
								}
								?>
							</select>
							<input type="submit" class="button-secondary button" value="<?php esc_html_e( 'Send Notice', 'edd_sl' ); ?>" data-license-id="<?php echo esc_attr( $license->ID ); ?>" />
							<span class="spinner"></span>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div id="item-edit-actions" class="edit-item" style="float: right; margin: 10px 0 0; display: block;">
			<input type="hidden" name="edd_action" value="update_license" />
			<?php wp_nonce_field( 'edd-sl-update-license', 'edd-sl-update-license-nonce' ); ?>
			<input type="submit" name="edd_sl_update_license" id="edd_sl_update_license" class="button button-primary" value="<?php _e( 'Update License', 'edd_sl' ); ?>" />
			<input type="hidden" name="license_id" value="<?php echo esc_attr( $license->ID ); ?>" />
		</div>
	</form>
</div>

<?php do_action( 'edd_sl_license_before_tables_wrapper', $license->key ); ?>

<div id="edd-item-tables-wrapper" class="item-section">
	<?php do_action( 'edd_sl_license_before_related_licenses', $license->key ); ?>

	<?php if ( $parent_has_license = (bool) edd_software_licensing()->get_license_key( $license->parent ) || ! empty( $has_children ) ) : ?>
		<h3>
			<?php if ( ! empty( $has_children ) ) : ?>
				<?php esc_html_e( 'Child Licenses:', 'edd_sl' ); ?>
			<?php else : ?>
				<?php esc_html_e( 'Parent License:', 'edd_sl' ); ?>
			<?php endif; ?>
			<?php
			$tooltip = new EDD\HTML\Tooltip(
				array(
					'title'   => __( 'Related Licenses', 'edd_sl' ),
					'content' => __( 'This table shows licenses related to this license, including relevant bundled licenses.', 'edd_sl' ),
				)
			);
			$tooltip->output();
			?>
		</h3>
		<table class="wp-list-table widefat striped related-licenses">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Product', 'edd_sl' ); ?></th>
					<th><?php esc_html_e( 'License Key', 'edd_sl' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php if ( isset( $parent_has_license ) && empty( $has_children ) ) : ?>
					<?php $parent_license = edd_software_licensing()->get_license( $license->parent ); ?>
					<tr>
						<td><?php echo $parent_license->get_name( false ); ?></td>
						<td><a href="<?php echo add_query_arg( 'license_id', $parent_license->ID ); ?>"><?php echo edd_software_licensing()->get_license_key( $parent_license->ID ); ?></a></td>
					</tr>
				<?php endif; ?>
				<?php if ( $has_children ) : ?>
					<?php foreach ( $has_children as $child_license ) : ?>
						<tr>
							<td><?php echo $child_license->get_name( false ); ?></td>
							<td><a href="<?php echo add_query_arg( 'license_id', $child_license->ID ); ?>"><?php echo edd_software_licensing()->get_license_key( $child_license->ID ); ?></a></td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>

		<?php do_action( 'edd_sl_license_after_related_licenses_table', $license->key ); ?>

	<?php endif; ?>

	<?php do_action( 'edd_sl_license_before_related_payments', $license->key ); ?>

	<h3>
		<?php
		esc_html_e( 'Related Payments:', 'edd_sl' );
		$tooltip = new EDD\HTML\Tooltip(
			array(
				'content' => __( 'This table shows the most recent payments relevant to this license, including upgrades and renewals.', 'edd_sl' ),
			)
		);
		$tooltip->output();
		?>
	</h3>
	<table class="wp-list-table widefat striped related-payments">
		<?php
		$orders = edd_get_orders(
			array(
				'id__in' => $license->payment_ids,
				'number' => 10,
			)
		);
		?>
		<thead>
			<tr>
				<th><?php esc_html_e( 'ID', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Amount', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Date', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Status', 'edd_sl' ); ?></th>
				<th><?php esc_html_e( 'Actions', 'edd_sl' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if ( ! empty( $orders ) ) : ?>
				<?php foreach ( $orders as $order ) : ?>
					<tr>
						<td><?php echo $order->id; ?></td>
						<td><?php echo edd_payment_amount( $order ); ?></td>
						<td><?php echo edd_date_i18n( strtotime( $order->date_created ), get_option( 'date_format' ) ); ?></td>
						<td><?php echo edd_get_payment_status( $order, true ); ?></td>
						<td>
							<a href="<?php echo admin_url( 'edit.php?post_type=download&page=edd-payment-history&view=view-order-details&id=' . $order->id ); ?>">
								<?php esc_html_e( 'View Details', 'edd_sl' ); ?>
							</a>
							<?php do_action( 'edd_sl_license_details_relate_payment_actions', $customer, $order ); ?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php else : ?>
				<tr><td colspan="5"><?php esc_html_e( 'No Payments Found', 'edd_sl' ); ?></td></tr>
			<?php endif; ?>
		</tbody>
	</table>

	<?php do_action( 'edd_sl_license_before_upgrade_paths', $license->key ); ?>

	<h3>
		<?php
		esc_html_e( 'Upgrade Paths:', 'edd_sl' );
		$tooltip = new EDD\HTML\Tooltip(
			array(
				'content' => __( 'This table shows the available upgrade paths for this license, along with a link to each specific upgrade. Upgrade paths can be added through the edit screen.', 'edd_sl' ),
			)
		);
		$tooltip->output();
		?>
	</h3>
	<table class="wp-list-table widefat striped upgrades">
		<thead>
			<tr>
				<th><?php _e( 'Product', 'edd_sl' ); ?></th>
				<th><?php _e( 'Amount', 'edd_sl' ); ?></th>
				<th><?php _e( 'Upgrade Link', 'edd_sl' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if ( $status == 'expired' ) {
				echo '<tr>';
				echo '<td colspan="3">' . __( 'This license must be renewed before it can be upgraded', 'edd_sl' ) . '</td>';
				echo '</tr>';
			} else {
				$upgrades = edd_sl_get_license_upgrades( $license->ID );

				if ( $upgrades && ! $license->parent ) {
					foreach ( $upgrades as $upgrade_id => $upgrade ) {
						echo '<tr>';
						echo '<td>';
						echo get_the_title( $upgrade['download_id'] );
						if ( isset( $upgrade['price_id'] ) && edd_has_variable_prices( $upgrade['download_id'] ) ) {
							echo ' - ' . edd_get_price_option_name( $upgrade['download_id'], $upgrade['price_id'] );
						}
						echo '</td>';
						echo '<td>' . edd_currency_filter( edd_sanitize_amount( edd_sl_get_license_upgrade_cost( $license->ID, $upgrade_id ) ) ) . '</td>';
						echo '<td>' . '<input type="text" readonly="readonly" class="edd_sl_upgrade_link" value="' . esc_url( edd_sl_get_license_upgrade_url( $license->ID, $upgrade_id ) ) . '"/></td>';
						echo '</tr>';
					}
				} elseif ( $license->parent ) {
					echo '<tr>';
					echo '<td colspan="3">&nbsp;&mdash;&nbsp;' . __( 'Bundled licenses can not be upgraded individually', 'edd_sl' ) . '</td>';
					echo '</tr>';
				} else {
					echo '<tr>';
					echo '<td colspan="3">' . __( 'No upgrade path available', 'edd_sl' ) . '</td>';
					echo '</tr>';
				}
			}
			?>
		</tbody>
	</table>
	<?php if ( edd_sl_renewals_allowed() && ! $license->is_lifetime ) : ?>
		<h3>
			<label for="edd-sl-renewal-url"><?php esc_html_e( 'Renewal URL:', 'edd_sl' ); ?></label>
			<?php
			$tooltip = new EDD\HTML\Tooltip(
				array(
					'content' => __( 'This URL can be provided to a customer for a direct link to your checkout screen with the license renewal pre-populated.', 'edd_sl' ),
				)
			);
			$tooltip->output();
			?>
		</h3>
		<table class="wp-list-table widefat striped">
			<tbody>
				<tr>
					<td><input id="edd-sl-renewal-url" type="text" class="large-text" value="<?php echo esc_url( $license->get_renewal_url() ); ?>" readonly></td>
				</tr>
			</tbody>
		</table>
	<?php endif; ?>

	<?php if ( ! $unsubscribed && ! $license->is_lifetime ) : ?>
		<h3>
			<label for="edd-sl-unsubscribe-url"><?php esc_html_e( 'Unsubscribe URL:', 'edd_sl' ); ?></label>
			<?php
			$tooltip = new EDD\HTML\Tooltip(
				array(
					'content' => __( 'This URL can be provided to a customer in order to unsubscribe from license renewal notification emails.', 'edd_sl' ),
				)
			);
			$tooltip->output();
			?>
		</h3>
		<table class="wp-list-table widefat striped">
			<tbody>
				<tr>
					<td><input id="edd-sl-unsubscribe-url" type="text" class="large-text" value="<?php echo esc_url( $license->get_unsubscribe_url() ); ?>" readonly></td>
				</tr>
			</tbody>
		</table>
	<?php endif; ?>
</div>

<?php
do_action( 'edd_sl_license_card_bottom', $license->key );
