<?php
/**
 * Upgrade Path Row.
 *
 * @since 3.9.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore
?>
<div class="edd-repeatable-row-header edd-draghandle-anchor">
	<span class="edd-repeatable-row-title" title="<?php esc_html_e( 'Upgrade Path', 'edd_sl' ); ?>">
		<?php
		/* translators: number of current upgrade path */
		printf( esc_html__( 'Upgrade Path: %s', 'edd_sl' ), '<span class="edd_price_id">' . esc_attr( $key ) . '</span>' );
		?>
		<input type="hidden" name="edd_sl_upgrade_path[<?php echo esc_attr( $key ); ?>][index]" class="edd_repeatable_index" value="<?php echo esc_attr( $index ); ?>"/>
	</span>
	<?php
	$actions = array(
		'remove' => '<a class="edd-remove-row edd-delete" data-type="file" aria-label="' . __( 'Remove upgrade path', 'edd_sl' ) . '">' . __( 'Remove', 'edd_sl' ) . '</a>',
	);
	?>
	<span class="edd-repeatable-row-actions">
		<?php echo implode( '&nbsp;&#124;&nbsp;', $actions ); ?>
	</span>
</div>
<div class="edd-form-row edd-repeatable-row-standard-fields edd-sl-upgrade-paths-row">
	<div class="edd-form-group edd-form-row__column edd-sl-option-download sl-upgrade-download">
		<label class="edd-form-group__label" for="edd_sl_upgrade_paths_<?php echo esc_attr( $key ); ?>">
			<?php esc_html_e( 'Download', 'edd_sl' ); ?>
		</label>

		<div class="edd-form-group__control">
			<?php
			$product_dropdown = new \EDD\HTML\ProductSelect(
				array(
					'name'     => 'edd_sl_upgrade_paths[' . esc_attr( $key ) . '][download_id]',
					'id'       => 'edd_sl_upgrade_paths_' . esc_attr( $key ),
					'selected' => ! empty( $args['download_id'] ) ? esc_attr( $args['download_id'] ) : false,
					'multiple' => false,
					'chosen'   => true,
					'class'    => 'edd-sl-upgrade-path-download edd-form-group__input',
				)
			);
			$product_dropdown->output();
			?>
		</div>
	</div>
	<div class="edd-form-group edd-form-row__column edd-sl-option-pricing">
		<label for="edd_sl_upgrade_paths_<?php echo esc_attr( $key ); ?>_price_id" class="edd-form-group__label edd-repeatable-row-setting-label"><?php esc_html_e( 'Price Option', 'edd_sl' ); ?></label>
		<div class="edd-form-group__control edd-sl-upgrade-price-control">
		<?php
		if ( edd_has_variable_prices( $args['download_id'] ) ) {

			$options = array();
			$prices  = edd_get_variable_prices( $args['download_id'] );
			if ( ! empty( $prices ) ) {
				foreach ( $prices as $price_key => $price ) {
					$options[ $price_key ] = $prices[ $price_key ]['name'];
				}
			}

			$select = new \EDD\HTML\Select(
				array(
					'name'                 => 'edd_sl_upgrade_paths[' . esc_attr( $key ) . '][price_id]',
					'id'                   => 'edd_sl_upgrade_paths_' . esc_attr( $key ) . '_price_id',
					'options'              => $options,
					'selected'             => esc_attr( $args['price_id'] ),
					'show_option_none'     => false,
					'show_option_all'      => false,
					'class'                => 'edd-sl-upgrade-path-price-id edd-form-group__input',
					'show_variations_only' => true,
				)
			);
			$select->output();
		} else {
			esc_html_e( 'N/A', 'edd_sl' );
		}
		?>
		</div>
	</div>
	<div class="edd-form-group edd-form-row__column edd-sl-upgrade-prorate sl-upgrade-prorate">
		<div class="edd-form-group__control">
			<?php
			$prorated_toggle = new \EDD\HTML\CheckboxToggle(
				array(
					'name'    => 'edd_sl_upgrade_paths[' . esc_attr( $key ) . '][pro_rated]',
					'id'      => 'edd_sl_upgrade_paths[' . esc_attr( $key ) . '][pro_rated]',
					'current' => ! empty( $args['pro_rated'] ) ? 1 : 0,
					'label'   => esc_html__( 'Prorate', 'edd_sl' ),
				)
			);

			$prorated_toggle->output();
			do_action( 'sl_after_prorate_checkbox', $key, $args );
			?>
		</div>
	</div>
	<div class="edd-form-group edd-form-row__column edd-sl-upgrade-discount sl-upgrade-discount">
		<label for="edd_sl_upgrade_paths_<?php echo esc_attr( $key ); ?>_discount" class="edd-repeatable-row-setting-label"><?php esc_html_e( 'Discount', 'edd_sl' ); ?></label>
		<div class="edd-form-group__control">
			<span class="edd-amount-type-wrapper">
				<?php
				$currency_position = edd_get_option( 'currency_position', 'before' );
				$currency_symbol   = edd_get_option( 'currency_symbol', '$' );

				// If the currency symbol is before the price, output the prefix.
				if ( 'before' === $currency_position ) {
					?>
					<span class="edd-input__symbol edd-input__symbol--prefix"><?php echo esc_html( $currency_symbol ); ?></span>
					<?php
				}
				?>
				<?php
				$discount_input = new \EDD\HTML\Text(
					array(
						'name'         => 'edd_sl_upgrade_paths[' . esc_attr( $key ) . '][discount]',
						'id'           => 'edd_sl_upgrade_paths_' . esc_attr( $key ) . '_discount',
						'value'        => esc_attr( $args['discount'] ),
						'placeholder'  => esc_html__( 'Amount', 'edd_sl' ),
						'class'        => array( 'edd-amount-input', 'medium-text', 'no-controls', 'symbol-' . $currency_position ),
						'include_span' => false,
					)
				);

				$discount_input->output();
				if ( 'after' === $currency_position ) {
					?>
					<span class="edd-input__symbol edd-input__symbol--suffix"><?php echo esc_html( $currency_symbol ); ?></span>
					<?php
				}
				?>
			</span>
		</div>
	</div>
</div>
<?php
