<?php
/**
 * Activations View
 *
 * @package     EDD
 * @subpackage  Admin/Activations
 */

do_action( 'edd_sl_license_before_licensed_urls', $license->key );

if ( edd_is_bundled_product( $license->download_id ) ) {
	return;
}

$args  = array(
	'number'        => 9999999,
	'license_id'    => $license->ID,
	'activated__in' => array( 1, 0 ),
	'orderby'       => 'date_created',
	'order'         => 'DESC',
);
$sites = edd_software_licensing()->activations_db->get_activations( $args );
?>

<div class="edd-sl__heading edd-sl__heading--activations">
	<h3>
		<?php
		esc_html_e( 'Licensed Activations:', 'edd_sl' );
		$tooltop = new \EDD\HTML\Tooltip(
			array(
				'content' => __( 'Use this form to add a new activation for this license. Once added, it will be considered active and will be included in the total activation count.', 'edd_sl' ),
			)
		);
		$tooltop->output();
		?>
	</h3>
	<?php
	if ( ! empty( $sites ) ) {
		?>
		<div class="edd-form-group">
			<div class="edd-form-group__control edd-toggle">
				<input type="checkbox" class="edd-requirement" name="show_inactive" id="edd_show_inactive" value="1" data-edd-requirement="show_inactive"/>
				<label for="edd_show_inactive"><?php esc_html_e( 'Show Inactive', 'edd_sl' ); ?></label>
			</div>
		</div>
		<?php
	}
	?>
</div>
<table class="wp-list-table widefat licensed-urls">
	<thead>
		<tr>
			<th><?php esc_html_e( 'Activation ID', 'edd_sl' ); ?></th>
			<th><?php esc_html_e( 'Status', 'edd_sl' ); ?></th>
			<th><?php esc_html_e( 'First API Request', 'edd_sl' ); ?></th>
			<th><?php esc_html_e( 'Last API Request', 'edd_sl' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if ( ! empty( $sites ) ) :
			foreach ( $sites as $site ) :
				$classes = array( 'row' );
				if ( ! $site->activated ) {
					$classes[] = 'edd-hidden';
				}
				?>
				<tr class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>" <?php echo ( empty( $site->activated ) ? 'data-edd-requires-show_inactive="true"' : '' ); ?>>
					<td>
						<div class="row-title">
							<?php echo esc_html( untrailingslashit( $site->site_name ) ); ?>
						</div>
						<?php
						$row_actions = array();
						if ( ! empty( $site->activated ) ) {
							$row_actions[] = array(
								'label' => __( 'Deactivate', 'edd_sl' ),
								'url'   => wp_nonce_url(
									add_query_arg(
										array(
											'edd-action' => 'deactivate_site',
											'site_id'    => $site->id,
											'license'    => $license->ID,
										)
									),
									'edd_deactivate_site_nonce'
								),
								'class' => 'trash',
							);
						} else {
							$row_actions[] = array(
								'label' => __( 'Activate', 'edd_sl' ),
								'url'   => add_query_arg(
									array(
										'edd-action' => 'insert_site',
										'site_id'    => $site->id,
										'license'    => $license->ID,
										'edd_add_site_nonce' => wp_create_nonce( 'edd_add_site_nonce' ),
									)
								),
								'class' => 'restore',
							);
							$row_actions[] = array(
								'label' => __( 'Delete', 'edd_sl' ),
								'url'   => wp_nonce_url(
									add_query_arg(
										array(
											'edd-action' => 'sl_delete_site',
											'site_id'    => $site->id,
											'license'    => $license->ID,
										)
									),
									'edd_delete_site_nonce'
								),
								'class' => 'trash',
							);
						}
						?>
						<div class="row-actions">
							<?php
							$action_html = array();
							foreach ( $row_actions as $action ) {
								$action_html[] = sprintf(
									'<span class="%s"><a href="%s">%s</a></span>',
									esc_attr( $action['class'] ),
									esc_url( $action['url'] ),
									esc_html( $action['label'] )
								);
							}
							echo implode( ' | ', $action_html );
							?>
						</div>
					</td>
					<td>
						<?php
						$status       = $site->activated ? 'active' : 'inactive';
						$status_badge = new \EDD\Utils\StatusBadge(
							array(
								'status' => $status,
								'label'  => $site->activated ? __( 'Active', 'edd_sl' ) : __( 'Inactive', 'edd_sl' ),
								'class'  => "edd-sl-admin-license-status-badge--{$status}",
							)
						);
						$status_badge->render();
						?>
					</td>
					<td>
						<?php
						if ( empty( $site->date_created ) || '0000-00-00 00:00:00' === $site->date_created ) {
							esc_html_e( 'Unknown', 'edd_sl' );
						} else {
							$date_created = array(
								esc_html( edd_date_i18n( $site->date_created ) ),
								esc_html( edd_date_i18n( $site->date_created, 'time' ) . ' ' . edd_get_timezone_abbr() ),
							);
							echo implode( '<br />', $date_created );
						}
						?>
					</td>
					<td>
						<?php
						if ( empty( $site->last_request ) || '0000-00-00 00:00:00' === $site->last_request ) {
							esc_html_e( 'Unknown', 'edd_sl' );
						} else {
							$last_request = array(
								esc_html( edd_date_i18n( $site->last_request ) ),
								esc_html( edd_date_i18n( $site->last_request, 'time' ) . ' ' . edd_get_timezone_abbr() ),
							);
							echo implode( '<br />', $last_request );
						}
						?>
					</td>
				</tr>
				<?php
			endforeach;
		else :
			?>
			<tr class="row"><td colspan="4"><?php esc_html_e( 'This license has not been activated.', 'edd_sl' ); ?></td></tr>
		<?php endif; ?>
		<tr class="edd-sl-add-licensed-url-row">
			<td colspan="4" class="edd-sl-add-licensed-url-td">
				<form method="post">
					<input type="text" class="regular-text" name="site_url" placeholder="<?php esc_html_e( 'New activation ID', 'edd_sl' ); ?>" required/>
					<?php wp_nonce_field( 'edd_add_site_nonce', 'edd_add_site_nonce' ); ?>
					<input type="hidden" name="edd_action" value="insert_site"/>
					<input type="hidden" name="license" value="<?php echo esc_attr( $license->ID ); ?>"/>
					<input type="submit" class="button-secondary button" value="<?php esc_html_e( 'Add', 'edd_sl' ); ?>"/>
				</form>
			</td>
		</tr>
	</tbody>
</table>
