document.addEventListener( 'DOMContentLoaded', function ( e ) {
	document.body.addEventListener( 'input', function ( event ) {
		if ( event.target.classList.contains( 'edd-order-item-refund-subtotal' ) ) {
			const orderItemID = event.target.closest( 'tr' ).dataset.orderItem;

			if ( orderItemID ) {
				const license = document.querySelector( '.edd-sl-license-order-item-' + orderItemID );
				if ( license ) {
					const total = parseFloat( event.target.value );
					const data_total = parseFloat( event.target.dataset.original );
					if ( total < data_total ) {
						license.classList.remove( 'edd-hidden' );
					} else {
						license.classList.add( 'edd-hidden' );
					}
				}
			}
		}
	} );
} );
