// Add an event listner to the "Process Licenses" button on the order details screen.
document.addEventListener( 'DOMContentLoaded', function () {
	const form = document.querySelector( '.order-licenses #edd-retroactive-processor' );
	if ( form ) {
		const button = form.querySelector( 'button' );
		button.addEventListener( 'click', eddRetroactiveProcessor );
	}
} );

/**
 * This function is called when the "Process Licenses" button is clicked on the order details screen.
 * It's a replacement for the EDD_Export.process_step function in the EDD_Export object because that requires a form element.
 *
 * @param {event} e
 */
function eddRetroactiveProcessor ( e ) {
	e.preventDefault();

	// disable the button
	const button = e.target;
	button.setAttribute( 'disabled', 'disabled' );
	button.classList.add( 'updating-message' );

	const form = document.querySelector( '#edd-retroactive-processor' );
	const notice_wrap = form.querySelector( '.notice-wrap' );
	if ( notice_wrap ) {
		notice_wrap.remove();
	}

	const div = document.createElement( 'div' );
	div.classList.add( 'notice-wrap' );
	div.innerHTML = '<div class="edd-progress"><div></div></div>';
	form.appendChild( div );

	eddRetroactiveProcessorProcessStep( form, 1 );
}

function eddRetroactiveProcessorProcessStep ( form, step ) {
	var formData = new FormData();
	formData.append( 'order_id', form.querySelector( 'input[name="order_id"]' ).value );
	formData.append( 'edd-export-class', form.querySelector( 'input[name="edd-export-class"]' ).value );
	formData.append( 'edd_ajax_export', form.querySelector( 'input[name="edd_ajax_export"]' ).value );

	// convert formData to a string
	var string = new URLSearchParams( formData ).toString();

	var data = new FormData();
	data.append( 'action', 'edd_do_ajax_export' );
	data.append( 'step', step );
	data.append( 'form', string );

	fetch( ajaxurl, {
		method: 'POST',
		body: data
	} ).then( function ( response ) {
		return response.json();
	} ).then( function ( response ) {
		if ( 'done' === response.step || response.error || response.success ) {
			const export_form = document.querySelector( '.edd-export-form' ).querySelector( '.edd-progress' ).parentElement.parentElement;
			const notice_wrap = export_form.querySelector( '.notice-wrap' );

			export_form.querySelector( 'button' ).classList.remove( 'updating-message' );
			export_form.querySelector( 'button' ).classList.add( 'updated-message' );
			setTimeout( function () {
				export_form.querySelector( 'button' ).removeAttribute( 'disabled' );
				export_form.querySelector( 'button' ).classList.remove( 'updated-message' );
				if ( notice_wrap ) {
					notice_wrap.remove();
				}

				location.reload();
			}, 3000 );

			if ( response.error ) {
				const error_message = response.message;
				notice_wrap.innerHTML = '<div class="updated error"><p>' + error_message + '</p></div>';
			} else if ( response.success ) {
				const success_message = response.message;
				notice_wrap.innerHTML = '<div id="edd-batch-success" class="updated notice"><p>' + success_message + '</p></div>';
				if ( response.data ) {
					Object.keys( response.data ).forEach( function ( key ) {
						// do something
					} );
				}
			}
		} else {
			// This really is likely a one step process but to work with the EDD export class we need to keep the process going.
			const progress = document.querySelector( '.edd-progress div' );
			progress.style.width = response.percentage + '%';

			eddRetroactiveProcessorProcessStep( form, parseInt( response.step ) );
		}
	} );
}
