<?php
/**
 * SelectTagAsset.php
 *
 * @package   edd-git-download-updater
 * @copyright Copyright (c) 2021, Easy Digital Downloads
 * @license   GPL2+
 * @since     1.3
 */

namespace EDD\GitDownloadUpdater\Providers;

interface SelectTagAsset {

	/**
	 * @param string $repoPath Repository path in the format: {org}/{repo}
	 * @param string $tagName  Name of the tag.
	 *
	 * @return array
	 */
	public function getAssetsFromRepoTag( $repoPath, $tagName );

}
