<?php
/**
 * ParsesApiErrors.php
 *
 * @package   edd-git-download-updater
 * @copyright Copyright (c) 2022, Easy Digital Downloads
 * @license   GPL2+
 * @since     1.3
 */

namespace EDD\GitDownloadUpdater\Providers;

use EDD\GitDownloadUpdater\Exceptions\ApiException;

interface ParsesApiErrors {

	/**
	 * Parses known errors from a failed API request and returns a display-friendly message.
	 *
	 * @since 1.3
	 *
	 * @param ApiException $e
	 *
	 * @return string
	 */
	public function parseApiErrors( ApiException $e );

}
