<?php
/**
 * ApiException.php
 *
 * @package   edd-git-download-updater
 * @copyright Copyright (c) 2021, Easy Digital Downloads
 * @license   GPL2+
 * @since     1.3
 */

namespace EDD\GitDownloadUpdater\Exceptions;

class ApiException extends \Exception {

	/**
	 * @var array|\WP_Error
	 */
	protected $apiResponse;

	/**
	 * @param $apiResponse
	 * @param $message
	 * @param $code
	 * @param $previous
	 */
	public function __construct( $apiResponse, $message = "", $code = 0, $previous = null ) {
		$this->apiResponse = $apiResponse;

		parent::__construct( $message, $code, $previous );
	}

	/**
	 * Returns the API response.
	 *
	 * @since 1.3
	 *
	 * @return array|\WP_Error
	 */
	public function getApiResponse() {
		return $this->apiResponse;
	}

}
