<?php
/**
 * Upgrades.php
 *
 * @package   edd-git-download-updater
 * @copyright Copyright (c) 2022, Easy Digital Downloads
 * @license   GPL2+
 * @since     1.3
 */

namespace EDD\GitDownloadUpdater\Admin;

class Upgrades {

	/**
	 * @var string Current version that's stored in the database.
	 * @since 1.3
	 */
	protected $db_version;

	/**
	 * Handles upgrades if they are needed.
	 *
	 * @since 1.3
	 *
	 * @return void
	 */
	public function maybeUpgrade() {
		/*
		 * Set the fallback version to 1.2.2, as we only started storing the version number
		 * in 1.3.
		 */
		$this->db_version = get_option( 'edd_git_download_updater_version', '1.2.2' );

		if ( version_compare( $this->db_version, EDD_GIT_VERSION, '!=' ) ) {
			$this->runUpgrades();

			update_option( 'edd_git_download_updater_version', EDD_GIT_VERSION );
		}
	}

	/**
	 * Runs upgrades.
	 *
	 * @since 1.3
	 *
	 * @return void
	 */
	protected function runUpgrades() {
		edd_debug_log( sprintf( 'Git: Running upgrades from version %s to version %s.', $this->db_version, EDD_GIT_VERSION ) );

		/*
		 * Delete the repo transient after each version change.
		 */
		delete_transient( 'edd_git_repos' );
	}

}
