<?php
/**
 * Handles outputting the custom price fields in the Download Metabox.
 *
 * @var int $download->ID ID of the download being edited.
 *
 * @package EDD_Custom_Prices
 */

$should_show = true;
if ( ! edd_cp_download_editor_has_sections() ) {
	$should_show = edd_cp_has_custom_pricing( $download->ID );
}
$default_price = get_post_meta( $download->ID, 'edd_cp_default_price', true );
if ( ! empty( $default_price ) ) {
	$default_price = edd_format_amount( $default_price );
}
$min_price = edd_format_amount( get_post_meta( $download->ID, 'edd_cp_min', true ) );

$bonus_item_defaults = array(
	'condition' => 'more_than',
	'price'     => '',
	'product'   => '',
);
$bonus_item          = (array) get_post_meta( $download->ID, 'bonus_item', true );
$bonus_item          = wp_parse_args( $bonus_item, $bonus_item_defaults );
$button_text         = get_post_meta( $download->ID, 'cp_button_text', true );
$currency_position   = edd_get_option( 'currency_position', 'before' );
?>

<div id="edd_cp_container" <?php echo $should_show ? '' : 'style="display: none;"'; ?> data-edd-requires-custom-prices="true">

	<div class="edd-form-row">
		<div class="edd-form-group edd-form-row__column">
			<label for="edd_cp_default_price" class="edd-form-group__label"><?php esc_html_e( 'Default: ', 'edd_cp' ); ?></label>
			<div class="edd-form-group__control">
				<?php if ( 'before' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
				<input type="text" name="edd_cp_default_price" id="edd_cp_default_price" class="edd-form-group__input edd-price-field" value="<?php echo esc_attr( $default_price ); ?>" placeholder="<?php echo esc_attr( edd_format_amount( '2.00' ) ); ?>"/>
				<?php if ( 'after' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
			</div>
			<p class="edd-form-group__help description"><?php esc_html_e( 'Leave empty for no default price', 'edd_cp' ); ?></p>
		</div>

		<div class="edd-form-group edd-form-row__column">
			<label for="edd_cp_price_min" class="edd-form-group__label"><?php esc_html_e( 'Min: ', 'edd_cp' ); ?></label>
			<div class="edd-form-group__control">
				<?php if ( 'before' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
				<input type="text" name="edd_cp_min" id="edd_cp_price_min" class="edd-form-group__input edd-price-field" value="<?php echo esc_attr( $min_price ); ?>" placeholder="<?php echo esc_attr( edd_format_amount( '1.99' ) ); ?>"/>
				<?php if ( 'after' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
			</div>
			<p class="edd-form-group__help description"><?php esc_html_e( 'Enter 0 for no min price', 'edd_cp' ); ?></p>
		</div>
	</div>

	<div class="edd-form-group">
		<label for="edd_cp_button_text" class="edd-form-group__label"><?php esc_html_e( 'Button text: ', 'edd_cp' ); ?></label>
		<div class="edd-form-group__control">
			<input type="text" name="cp_button_text" id="edd_cp_button_text" class="edd-form-group__input" value="<?php echo esc_attr( $button_text ); ?>" placeholder="<?php esc_attr_e( 'Name your price', 'edd_cp' ); ?>"/>
		</div>
		<p class="edd-form-group__help description"><?php esc_html_e( 'Edit the default button text, displays the price by default', 'edd_cp' ); ?></p>
	</div>

	<p><strong><?php esc_html_e( 'Bonus item', 'edd_cp' ); ?></strong></p>
	<p class="description"><?php esc_html_e( 'A bonus item allow you to give away an item for free when the custom price meets set conditions.', 'edd_cp' ); ?></p>
	<div class="edd-form-row">
		<div class="edd-form-group edd-form-row__column">
			<label for="bonus_item_condition" class="edd-form-group__label"><?php esc_html_e( 'Condition: ', 'edd_cp' ); ?></label>
			<div class="edd-form-group__control">
				<select id="bonus_item_condition" name="bonus_item[condition]">
					<?php
					$conditions = array(
						'more_than' => __( 'More than', 'edd_cp' ),
						'less_than' => __( 'Less than', 'edd_cp' ),
						'equal_to'  => __( 'Equal to', 'edd_cp' ),
					);
					foreach ( $conditions as $value => $label ) {
						printf(
							'<option value="%s" %s>%s</option>',
							esc_attr( $value ),
							selected( $bonus_item['condition'], $value, false ),
							esc_html( $label )
						);
					}
					?>
				</select>
			</div>
		</div>
		<div class="edd-form-group edd-form-row__column">
			<label for="bonus_item_price" class="edd-form-group__label"><?php esc_html_e( 'Price: ', 'edd_cp' ); ?></label>
			<div class="edd-form-group__control">
				<?php if ( 'before' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
				<input type="text" id="bonus_item_price" name="bonus_item[price]" class="edd-form-group__input edd-price-field" value="<?php echo esc_attr( edd_format_amount( $bonus_item['price'] ) ); ?>" placeholder="<?php esc_attr_e( 'Price', 'edd_cp' ); ?>" />
				<?php if ( 'after' === $currency_position ) : ?>
					<?php echo esc_html( edd_currency_filter( '' ) ); ?>
				<?php endif; ?>
			</div>
		</div>
		<div class="edd-form-group edd-form-row__column edd-custom-prices__bonus">
			<label for="bonus_item_product" class="edd-form-group__label"><?php esc_html_e( 'Product: ', 'edd_cp' ); ?></label>
			<div class="edd-form-group__control">
				<?php
				$select = new \EDD\HTML\ProductSelect(
					array(
						'id'                => 'bonus_item_product',
						'name'              => 'bonus_item[product]',
						'show_option_empty' => __( 'None', 'edd_cp' ),
						'show_option_all'   => false,
						'selected'          => isset( $bonus_item['product'] ) ? $bonus_item['product'] : '',
						'chosen'            => true,
					)
				);
				$select->output();
				?>
			</div>
		</div>
		<div class="edd-form-group edd-form-row__column">
			<button class="button button-link button-link-delete edd_cp_remove_repeatable"><?php esc_html_e( 'Remove Bonus Item', 'edd_cp' ); ?></button>
		</div>
	</div>
</div>
