<?php

namespace EDD\CustomPrices\Admin;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Admin\Downloads\Editor\Section;

/**
 * All Access section.
 *
 * @since 1.5.10
 */
class Metabox extends Section {

	/**
	 * Section ID.
	 *
	 * @since 1.5.10
	 * @var string
	 */
	protected $id = 'custom_prices';

	/**
	 * Section priority.
	 *
	 * @since 1.5.10
	 * @var int
	 */
	protected $priority = 80;

	/**
	 * Section icon.
	 *
	 * @since 1.5.10
	 * @var string
	 */
	protected $icon = 'edit-large';

	/**
	 * What the section supports.
	 *
	 * @since 1.5.10
	 * @var array
	 */
	protected $requires = 'custom-prices';

	/**
	 * Get the section label.
	 *
	 * @since 1.5.10
	 * @return string
	 */
	public function get_label() {
		return __( 'Custom Pricing', 'edd_cp' );
	}

	/**
	 * Render the section.
	 *
	 * @since 1.5.10
	 * @return void
	 */
	public function render() {
		$download = $this->item;
		// Check if the user can edit this specific download ID (post ID).
		if ( ! $download || ! current_user_can( 'edit_product', $download->ID ) ) {
			return;
		}

		include EDD_CUSTOM_PRICES_DIR . 'views/custom-price-metabox.php';

		if ( function_exists( 'edd_recurring_metabox_custom_options' ) ) {
			edd_recurring_metabox_custom_options( $download->ID );
		}
	}
}
