<?php
/**
 * Deprecated functions.
 *
 * @package EDD_Custom_Prices
 * @since 1.5.9
 */

defined( 'ABSPATH' ) || exit;

/**
 * Filter option text on product item
 *
 * @deprecated 1.5.8
 *
 * @param string $text The text to be filtered.
 * @param int    $item_id The item ID.
 * @param array  $options The options.
 */
function edd_cp_get_price_name( $text, $item_id, $options ) {
	_deprecated_function( __FUNCTION__, '1.5.8', 'edd_cp_modify_cart_item_name' );
	if ( isset( $options['is_cp_bonus'] ) ) {
		return __( ' *bonus item*', 'edd_cp' );
	} elseif ( edd_cp_has_custom_pricing( $item_id ) && isset( $options['custom_price'] ) ) {
		if ( edd_has_variable_prices( $item_id ) ) {
			return __( 'custom price', 'edd_cp' );
		} else {
			return __( ' - custom price', 'edd_cp' );
		}
	}
	return $text;
}

/**
 * Filter cart item price name (similar to above)
 *
 * @deprecated 1.5.8
 *
 * @param string $name The name to be filtered.
 * @param int    $item_id The item ID.
 * @param int    $price_id The price ID.
 * @param array  $item The item.
 *
 * @return string
 */
function edd_cp_get_cart_item_price_name( $name, $item_id, $price_id, $item ) {
	_deprecated_function( __FUNCTION__, '1.5.8', 'edd_cp_modify_cart_item_name' );
	if ( isset( $item['options']['is_cp_bonus'] ) ) {
		return __( ' *bonus item*', 'edd_cp' );
	} elseif ( edd_cp_has_custom_pricing( $item_id ) && isset( $item['options']['custom_price'] ) ) {

		if ( edd_single_price_option_mode( $item_id ) && isset( $item['options']['custom_price'][ $price_id ] ) ) {
			return $name . __( ' (custom price)', 'edd_cp' );
		} elseif ( ! edd_single_price_option_mode( $item_id ) ) {
			return $name . __( ' (custom price)', 'edd_cp' );
		}
	}
	return $name;
}

/**
 * Show notice if EDD is disabled, and deactivate Custom Prices
 *
 * @deprecated 1.5.9
 */
function edd_cp_admin_notice() {
	if ( ! class_exists( 'Easy_Digital_Downloads' ) ) {
		deactivate_plugins( 'edd-custom-prices/edd-custom-prices.php' ); ?>
		<div class="error"><p><?php echo esc_html_e( '<strong>Error:</strong> Easy Digital Downloads must be activated to use the Custom Prices extension.', 'edd_cp' ); ?></p></div>
		<?php
	}
}
